<?php

/**
 * Imports Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
require_once APPPATH . 'libraries/fpdf.php';
require_once APPPATH . 'libraries/FPDI/src/autoload.php';
// require 'PHPExcel/Classes/PHPExcel.php';
// require_once APPPATH . 'libraries/tcpdf/tcpdf.php';
// require_once APPPATH . 'libraries/mpdf/src/Mpdf.php';
 include APPPATH.'third_party/PHPExcel/PHPExcel.php';
         include APPPATH.'third_party/PHPExcel/PHPExcel/IOFactory.php';
use libraries\BaseController;
use Smalot\PdfParser\Parser;
class Imports extends BaseController
{

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();
		ini_set('memory_limit', '100000M');
// 		ini_set('post_max_size', '100000M');
// ini_set('upload_max_filesize', '100000M');

		// load model
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
		$this->load->model('Sales_model');
		$this->load->model('Groups_model');
		$this->load->model('Suppliers_model');
		

		$this->load->model('Pabrik_model');
		$this->load->model('Categories_model');
	}

	public function index()
	{
		$data['content_title'] = 'Import Data';

		$data['msg_unit'] = $this->session->userdata('msg_unit');

		$this->twiggy_display('adm/imports/index', $data);
		$this->session->unset_userdata('msg_unit');
	}

	public function import_data()
	{
	   
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName        = str_replace(" ", "_", $fileName_before);

		$path           = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes   = 'xls|xlsx|csv';
        $upload_image = $_FILES['item_file_name']['name'];

        if ($upload_image) {
            $config['allowed_types'] = '*';
            $config['max_size']      = '4048'; //dalam kilo bite(kb)
            $config['upload_path']   = './assets/excels/upload_file/';

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('item_file_name')) {
                 $this->upload->data('item_file_name');
            } else {

                echo $this->upload->display_errors();
            }
        }

		$inputFileName = $path . $fileName;

		try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader     = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel   = $objReader->load($inputFileName);
		} catch (Exception $e) {
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

// 		if (substr($fileName_before, 0, 3) == "sho" || substr($fileName_before, 0, 3) == "SHO" || substr($fileName_before, 0, 3) == "Sho") {
			$this->import_shopee();
// 		}

// 		if (substr($fileName_before, 0, 3) == "tok" || substr($fileName_before, 0, 3) == "TOK" || substr($fileName_before, 0, 3) == "Tok") {
// 			$this->import_tokopedia();
// 		}

// 		if (substr($fileName_before, 0, 3) == "tik"  || substr($fileName_before, 0, 3) == "TIK" || substr($fileName_before, 0, 3) == "Tik") {
// 			$this->import_tiktok();
// 		}
	}

	public function import_tiktok()
	{
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName        = str_replace(" ", "_", $fileName_before);

		$path           = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes   = 'xls|xlsx|csv';

		if (!empty($_FILES['item_file_name']['name'])) {
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

		$inputFileName = $path . $fileName;

		try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader     = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel   = $objReader->load($inputFileName);
		} catch (Exception $e) {
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$number_tr = 0;
		$header_id = 0;

		$number_generator = $this->Sales_model->sales_number();
		$no = 0;
		$insert = false;
		$save_detail = false;
		for ($row = 3; $row <= $highestRow; $row++) {                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);

			if ($number_tr != $rowData[0][1]) {
				$total = str_replace('IDR ', '', $rowData[0][22]);
				// $delivery_fee = str_replace('IDR ', '', $rowData[0][17]);
				$data = [
					"number"        => $number_generator + ($no++),
					"dropshipper"   => $rowData[0][0],
					"number_order"  => $rowData[0][1],
					"number_resi"   => (isset($rowData[0][34]) == 1 ? $rowData[0][34] : ''),
					"courier"       => (isset($rowData[0][36]) == 1 ? $rowData[0][36] : ''),
					"date"          => $rowData[0][24],
					"customer_id"   => 0,
					"customer_name" => $rowData[0][38],
					"total"         => str_replace('.', '', $total),
					"delivery_fee"  => 0,
					"user_id"       => 1,
					"description"   => (isset($rowData[0][37]) == 1 ? $rowData[0][37] : ''),
					"timestamp"     => date_now(),
					"division"      => logged_user('division')
				];
				$insert = $this->db->insert("sales_header", $data);
				$header_id = $this->db->insert_id();

				$number_tr = $rowData[0][1];
			}

			$where_detail = array("item_name" => $rowData[0][12]);
			$exist_detail = $this->Items_model->get_data($where_detail)->row();

			$price = str_replace('IDR ', '', $rowData[0][12]);
			// $discount_amount1 = str_replace('IDR ', '', $rowData[0][13]);
			// $discount_amount2 = str_replace('IDR ', '', $rowData[0][14]);
			// $ttl_dsc_amt = str_replace('.', '', $discount_amount1) + str_replace('.', '', $discount_amount2);

			$detail_data[] = [
				'header_id'           => $header_id,
				'item_id'             => ($exist_detail != null ? $exist_detail->item_id : 0),
				'item_code'           => $rowData[0][7],
				'item_name'           => $rowData[0][8],
				'quantity'            => str_replace('.', '', $rowData[0][10]),
				'unit'                => '',
				'price'               => str_replace('.', '', $price),
				'discount_percentage' => 0,
				'discount_amount'     => 0,
				'amount'              => (str_replace('.', '', $price) * str_replace('.', '', $rowData[0][10])),
				"division"            => logged_user('division')
			];
		}

		if ($insert) {
			$save_detail = $this->Sales_model->save_detail($detail_data, true);
		}

		unlink($inputFileName);

		$msg = '';
		if ($save_detail) {
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}

		redirect('adm/imports/');
	}

	public function import_shopee()
	{
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName        = str_replace(" ", "_", $fileName_before);

		$path           = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes   = 'xls|xlsx|csv';
        
         $upload_image = $_FILES['item_file_name']['name'];

        if ($upload_image) {
            $config['allowed_types'] = '*';
            $config['max_size']      = '4048'; //dalam kilo bite(kb)
            $config['upload_path']   = './assets/excels/upload_file/';

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('item_file_name')) {
                 $this->upload->data('item_file_name');
            } else {

                echo $this->upload->display_errors();
            }
        }
// 		if (!empty($_FILES['item_file_name']['name'])) {
// 			upload_file($path, $item_file_name, null, $allowedTypes);
// 		}

		$inputFileName = $path . $fileName;

		try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader     = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel   = $objReader->load($inputFileName);
		} catch (Exception $e) {
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$number_tr = 0;
		$header_id = 0;

		$number_generator = $this->Sales_model->sales_number();
		$no = 0;
		$insert = false;
		$save_detail = false;
		for ($row = 2; $row <= $highestRow; $row++) {                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);

			// $where = array("customer_name" => $rowData[0][40]);
			// $exist = $this->Customers_model->get_data($where)->row();


			if ($number_tr != $rowData[0][0]) {
				$data = [
					"number"        => $number_generator + ($no++),
					"number_order"  => (isset($rowData[0][0]) == NULL ? '' : $rowData[0][0]),
					"number_resi"   => (isset($rowData[0][4]) == 1 ? $rowData[0][4] : ''),
					"courier"       => (isset($rowData[0][5]) == 1 ? $rowData[0][5] : ''),
					"date"          => (isset($rowData[0][9]) == NULL ? '0000-00-00' : $rowData[0][9]),
					"customer_id"   => 0,
					"customer_name" => (isset($rowData[0][40]) == NULL ? '' : $rowData[0][40]),
					"total"         => str_replace('.', '', $rowData[0][36]),
					"delivery_fee"  => str_replace('.', '', $rowData[0][37]),
					"user_id"       => 1,
					"description"   => (isset($rowData[0][38]) == 1 ? $rowData[0][38] : ''),
					"timestamp"     => date_now(),
					"division"      => logged_user('division')
				];
				$insert = $this->db->insert("sales_header", $data);
				$header_id = $this->db->insert_id();

				$number_tr = $rowData[0][0];
			}

			$where_detail = array("item_code" => $rowData[0][13]);
			$exist_detail = $this->Items_model->get_data($where_detail)->row();
			$detail_data[] = [
				'header_id'           => $header_id,
				'item_id'             => 0,
				// ($exist_detail != null ? $exist_detail->item_id : 0)
				'item_code'           => $rowData[0][13],
				'item_name'           => $rowData[0][12],
				'quantity'            => str_replace('.', '', $rowData[0][17]),
				'unit'                => '',
				'price'               => str_replace('.', '', $rowData[0][15]),
				'discount_percentage' => 0,
				'discount_amount'     => str_replace('.', '', $rowData[0][19]),
				'amount'              => str_replace('.', '', $rowData[0][18]),
				"division"      => logged_user('division')
			];
		}

		if ($insert) {
			$save_detail = $this->Sales_model->save_detail($detail_data, true);
		}

		unlink($inputFileName);

		$msg = '';
		if ($save_detail) {
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}

		redirect('adm/imports/');
	}

	public function import_tokopedia()
	{
		$fileName_before = $_FILES['item_file_name']['name'];
		$fileName        = str_replace(" ", "_", $fileName_before);

		$path           = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes   = 'xls|xlsx|csv';

		if (!empty($_FILES['item_file_name']['name'])) {
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

		$inputFileName = $path . $fileName;

		try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader     = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel   = $objReader->load($inputFileName);
		} catch (Exception $e) {
			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . $e->getMessage());
		}

		$sheet         = $objPHPExcel->getSheet(0);
		$highestRow    = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();

		$number_tr = 0;
		$header_id = 0;

		$number_generator = $this->Sales_model->sales_number();
		$no = 0;
		$insert = false;
		$save_detail = false;
		for ($row = 6; $row <= $highestRow; $row++) {                  //  Read a row of data into an array                 
			$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);

			// $where = array("customer_name" => $rowData[0][25]);
			// $exist = $this->Customers_model->get_data($where)->row();


			if ($rowData[0][1] != NULL) {

				$data = [
					"number"        => $number_generator + ($no++),
					"dropshipper"   => $rowData[0][0],
					"number_order"  => $rowData[0][2],
					"number_resi"   => (isset($rowData[0][35]) == 1 ? $rowData[0][35] : ''),
					"courier"       => (isset($rowData[0][33]) == 1 ? $rowData[0][33] : ''),
					"date"          => change_format_date($rowData[0][3]),
					"customer_id"   => 0,
					"customer_name" => $rowData[0][26],
					"total"         => $rowData[0][25],
					"delivery_fee"  => 0,
					"user_id"       => 1,
					"description"   => '',
					"timestamp"     => date_now(),
					"division"      => logged_user('division')
				];

				$insert = $this->db->insert("sales_header", $data);
				$header_id = $this->db->insert_id();

				$number_tr = $rowData[0][2];
			}

			$where_detail = array("item_name" => $rowData[0][8]);
			$exist_detail = $this->Items_model->get_data($where_detail)->row();
			$detail_data[] = [
				// 'header_id'           => $header_id,
				// 'item_id'             => ($exist_detail != null ? $exist_detail->item_id : 0),
				// 'item_name'           => $rowData[0][8],
				// 'quantity'            => str_replace('.', '', $rowData[0][13]),
				// 'unit'                => '',
				// 'price'               => str_replace('.', '', $rowData[0][14]),
				// 'discount_percentage' => (($rowData[0][15] / $rowData[0][14])),
				// 'discount_amount'     => str_replace('.', '', $rowData[0][15]),
				// 'amount'              => str_replace('.', '', $rowData[0][16]),

				'header_id'           => $header_id,
				'item_id'             => ($exist_detail != null ? $exist_detail->item_id : 0),
				'item_code'           => $rowData[0][11],
				'item_name'           => $rowData[0][9],
				'quantity'            => $rowData[0][14],
				'unit'                => '',
				'price'               => $rowData[0][15],
				'discount_percentage' => 0,
				'discount_amount'     => $rowData[0][16],
				'amount'              => $rowData[0][17],
				"division"      => logged_user('division')
			];
		}

		if ($insert) {
			$save_detail = $this->Sales_model->save_detail($detail_data, true);
		}

		unlink($inputFileName);

		$msg = '';
		if ($save_detail) {
			$msg = true;
			$this->session->set_userdata('msg_unit', $msg);
		}

		redirect('adm/imports/');
	}
	
	public function import_items() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("item_name" => $rowData[0][6]);
				$exist = $this->Items_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){

					// Sesuaikan key array dengan nama kolom di database
				
					$category_name = ($rowData[0][2]  == NULL ? "ALL" : $rowData[0][2]);
				// 	$supplier_name       = ($rowData[0][9]  == NULL ? "ALL" : $rowData[0][9]);
					$pabrik_name       = ($rowData[0][3]  == NULL ? "ALL" : $rowData[0][3]);
					$grup_name       = ($rowData[0][0]  == NULL ? "ALL" : $rowData[0][0]);
					if($category_name != ""){
						$where_category   = array("category" => $category_name);
						$get_data_category = $this->Categories_model->get_data($where_category)->row();
						if($get_data_category){
							$category_name = $get_data_category->categories_id;
						}
					}
				// 	if($supplier_name != ""){
				// 		$where_supplier    = array("supplier_name" => $supplier_name);
				// 		$get_data_supplier = $this->Suppliers_model->get_data($where_supplier)->row();
				// 		if($get_data_supplier){
				// 			$supplier_name = $get_data_supplier->supplier_id;
				// 		}
				// 	}

					if($pabrik_name != ""){
						$where_pabrik    = array("kode_pabrik" => $pabrik_name);
						$get_data_pabrik = $this->Pabrik_model->get_data($where_pabrik)->row();
						if($get_data_pabrik){
							$pabrik_name = $get_data_pabrik->id_pabrik;
						}
					}
					if($grup_name != ""){
						$where_group    = array("group_code" => $grup_name);
						$get_data_group = $this->Groups_model->get_data($where_group)->row();
						if($get_data_group){
							$grup_name = $get_data_group->group_id;
						}
					}


					$data = [
				// 		"item_code"                       => $rowData[0][4],
						"item_name"                       => ($rowData[0][1]  == NULL ? "" : $rowData[0][1]),
						"item_group_id"                       => $grup_name,
						"obat_category_id"                       => $category_name,
						"obat_pabrik_id"                   => $pabrik_name,
						"item_supplier_id"             => 81,
						"large_unit"                      => ($rowData[0][4]  == NULL ? "" : $rowData[0][4]),
						"large_unit_contain"                      => 1,
						"last_purchase_price_large_unit"  => ($rowData[0][6]  == NULL ? "" : $rowData[0][6]),
            			"last_selling_price_large_unit"   => ($rowData[0][7]  == NULL ? "" : $rowData[0][7]),
                        "last_selling_price_large_unit2"   => ($rowData[0][8]  == NULL ? "" : $rowData[0][8]),
                        "stok_awal"   => ($rowData[0][9]  == NULL ? "" : $rowData[0][9]),
					];
					$insert = $this->db->insert("master_items", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_group() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("group_name" => $rowData[0][1]);
				$exist = $this->Groups_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){


					$data = [
						"group_name"                       => $rowData[0][1],
						"group_code"                       => $rowData[0][0],
					];
					$insert = $this->db->insert("master_groups", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	public function import_pabrik() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("nama_pabrik" => $rowData[0][1]);
				$exist = $this->Pabrik_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){


					$data = [
					    "kode_pabrik"                       => $rowData[0][0],
						"nama_pabrik"                       => $rowData[0][1],
					];
					$insert = $this->db->insert("master_pabrik", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	public function import_supplier() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("supplier_name" => $rowData[0][1]);
				$exist = $this->Suppliers_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){


					$data = [
					   // "kode_pabrik"                       => $rowData[0][0],
						"supplier_name"                       => $rowData[0][1],
					];
					$insert = $this->db->insert("master_suppliers", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_warna() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("color_name" => $rowData[0][0]);
				$exist = $this->Colors_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){


					$data = [
						"color_name"                       => $rowData[0][0],
					];
					$insert = $this->db->insert("master_colors", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
	public function import_type() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("type_name" => $rowData[0][0]);
				$exist = $this->Types_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){


					$data = [
						"type_name"                       => $rowData[0][0],
					];
					$insert = $this->db->insert("master_types", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	public function import_ukuran() {
        $fileName_before = $_FILES['item_file_name']['name'];
		$fileName = str_replace(" ", "_", $fileName_before);
          
        $path = './assets/excels/upload_file/';
		$item_file_name = 'item_file_name';
		$allowedTypes = 'xls|xlsx|csv';

		if(!empty($_FILES['item_file_name']['name'])){
			upload_file($path, $item_file_name, null, $allowedTypes);
		}

        $inputFileName = $path.$fileName;
		
        try {
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objPHPExcel = $objReader->load($inputFileName);
		} catch(Exception $e) {
			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
		}

		$sheet = $objPHPExcel->getSheet(0);
		$highestRow = $sheet->getHighestRow();
		$highestColumn = $sheet->getHighestColumn();


		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

				$where = array("size_name" => $rowData[0][0]);
				$exist = $this->Sizes_model->get_data($where)->row();
                if (empty($rowData)) {
                    $isValidRow = false;
                    break;
                }
				if($exist == null){


					$data = [
						"size_name"                       => $rowData[0][0],
					];
					$insert = $this->db->insert("master_sizes", $data);

					if($insert){

						
					}
				}
			
					
		}
		unlink($inputFileName);

		$msg = '';
		if($insert){
			$msg = true;
			$this->session->set_userdata('msg_item', $msg);
		}
		
        redirect('adm/imports/');
	}
	
// 	public function import_warna() {
//         $fileName_before = $_FILES['item_file_name']['name'];
// 		$fileName = str_replace(" ", "_", $fileName_before);
          
//         $path = './assets/excels/upload_file/';
// 		$item_file_name = 'item_file_name';
// 		$allowedTypes = 'xls|xlsx|csv';

// 		if(!empty($_FILES['item_file_name']['name'])){
// 			upload_file($path, $item_file_name, null, $allowedTypes);
// 		}

//         $inputFileName = $path.$fileName;
		
//         try {
// 			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
// 			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
// 			$objPHPExcel = $objReader->load($inputFileName);
// 		} catch(Exception $e) {
// 			die('Error loading file "'.pathinfo($inputFileName,PATHINFO_BASENAME).'": '.$e->getMessage());
// 		}

// 		$sheet = $objPHPExcel->getSheet(0);
// 		$highestRow = $sheet->getHighestRow();
// 		$highestColumn = $sheet->getHighestColumn();


// 		for ($row = 2; $row <= $highestRow; $row++){                  //  Read a row of data into an array                 
// 				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL,	TRUE, TRUE);   

// 				$where = array("color_name" => $rowData[0][0]);
// 				$exist = $this->Items_model->get_data($where)->row();
//                 if (empty($rowData)) {
//                     $isValidRow = false;
//                     break;
//                 }
// 				if($exist == null){


// 					$data = [
// 						"color_name"                       => $rowData[0][0],
// 					];
// 					$insert = $this->db->insert("master_colors", $data);

// 					if($insert){

						
// 					}
// 				}
			
					
// 		}
// 		unlink($inputFileName);

// 		$msg = '';
// 		if($insert){
// 			$msg = true;
// 			$this->session->set_userdata('msg_item', $msg);
// 		}
		
//         redirect('adm/imports/');
// 	}
	
	
	
	public function export_items() {
		
		$get_data = $this->Items_model->get_data()->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("BARANG")
							   ->setSubject("BARANG")
							   ->setDescription("BARANG")
							   ->setKeywords("BARANG");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFFF00')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

		// Buat header tabel pada baris ke 1
	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Type");
	    $excel->setActiveSheetIndex(0)->setCellValue('B1', "Warna");
	    $excel->setActiveSheetIndex(0)->setCellValue('C1', "Ukuran");
	    $excel->setActiveSheetIndex(0)->setCellValue('D1', "Group");
	   // $excel->setActiveSheetIndex(0)->setCellValue('E1', "SKU");
	    $excel->setActiveSheetIndex(0)->setCellValue('E1', "kode");
	     $excel->setActiveSheetIndex(0)->setCellValue('F1', "nama");
	    $excel->setActiveSheetIndex(0)->setCellValue('G1', "besar");
	    $excel->setActiveSheetIndex(0)->setCellValue('H1', "harga_beli");
	    $excel->setActiveSheetIndex(0)->setCellValue('I1', "e_besar");
	   
	    $excel->getActiveSheet()->getStyle('A1:J1')->applyFromArray($style_col);

	    $no = 1; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 2; // Set baris pertama untuk isi tabel adalah baris ke 4
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $get_row->type_name);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, strval($get_row->color_name));
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, strval($get_row->size_name));
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, strval($get_row->group_name));
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->item_code);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, $get_row->last_purchase_price_large_unit);
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, $get_row->last_selling_price_large_unit);
            // $excel->getActiveSheet();

	      	$no++; // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
		
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("BARANG");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'BARANG_'.$date_now.'.xlsx';
    // ob_end_clean();
	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	   // 
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	   // ob_end_clean();
	}

	

	public function process_upload() {

        // Configuration for file upload
        $config['upload_path']   = './././assets/uploads/';
        $config['allowed_types'] = 'pdf';
        $config['max_size']      = 100000; // Set the maximum file size in KB

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('pdf_file')) {
            // File upload failed, display error message
            // $data['error'] = $this->upload->display_errors();
            // $this->load->view('upload_pdf', $data);
            echo $this->upload->display_errors();
        } else {
            // File uploaded successfully, process the PDF and extract text
            $pdfFilePath = './././assets/uploads/' . $this->upload->data('file_name');

            $parser = new Parser();
            
            

            try {
                $pdf = $parser->parseFile($pdfFilePath);
                //  $newPdf = new FPDF();
                //  $pageCount = $newPdf->setSourceFile($pdfFilePath);
                // $tplIdx = $newPdf->importPage(1);

                // $newPdf->useTemplate($tplIdx, 10, 10, 190);
                // $newPdf->AddPage();
                // $newPdf->SetFont('Arial', '', 12);
                // $newPdf->MultiCell(0, 10, $text);
                // $outputPdfFile =  'Tes.pdf';
                // // Save the new PDF to the uploads folder
                // $newPdf->Output('./././assets/uploads/' . $outputPdfFile, 'F');
                
                $text = $pdf->getText();
                $totalPages = count($pdf->getPages());

            // Split the PDF file into as many chunks as there are pages, extract text, and upload the split pages
            // $this->splitAndExtractText($pdf, $pdfFilePath, $totalPages);
            } catch (Exception $e) {
                $text = 'Error: ' . $e->getMessage();
            }
            // $timestamp = time();
            
           
            
			// Split the text by lines
			// preg_match('/Resi:\s*SPXID(\w+)/s', $text, $matches);

			// preg_match('/No\. Pesanan: (\w+)/s', $text, $matches);

			// if (isset($matches[1])) {
			// 	$noPesanan = $matches[1];
			// 	echo $noPesanan;
			// }
			// echo nl2br($text);
// 			$noPesananArray = [];

// 			// Use regular expression to find all occurrences of the "No. Pesanan" part
// 			$noPesananArraySplitted = [];

//             // Use regular expression to find all occurrences of the "No. Pesanan" part
//             preg_match_all('/No\. Pesanan: (\w+)/', $text, $matches);
            
//             // Process each matched section to extract the "No. Pesanan" value
//             foreach ($matches[1] as $noPesanan) {
//                 // Store the extracted "No. Pesanan" in the array
//                 $noPesananArray[] = $noPesanan;
//             }
            
//             // Remove duplicates from the array
//             $uniqueNoPesananArray = array_unique($noPesananArray);
            
//             // Split each unique "No. Pesanan" value into an array of words
//             $splitNoPesananArray = [];
            

//             // Split, extract text, and upload each page as a separate file
//                 foreach ($uniqueNoPesananArray as $noPesanan) {
//                     $words = explode(" ", $noPesanan);
//                     $splitNoPesananArray[] = $words;
                   
//                 	$noPesananArraySplitted = [
//                 	    'pdf_file_name' => $date_now . '.pdf',
//                 		'no_pesanan' => implode(" ", $words)
//                 	];
//                 	$insert = $this->db->insert("pesanan_pdf", $noPesananArraySplitted);
//                 }
                
                 $noPesananArray = [];

			// Use regular expression to find all occurrences of the "No. Pesanan" part
			$noPesananArraySplitted = [];

            // Use regular expression to find all occurrences of the "No. Pesanan" part
            preg_match_all('/No\. Pesanan: (\w+)/', $text, $matches);
            
            // Process each matched section to extract the "No. Pesanan" value
            foreach ($matches[1] as $noPesanan) {
                // Store the extracted "No. Pesanan" in the array
                $noPesananArray[] = $noPesanan;
            }
            
             
            
            // Remove duplicates from the array
            $uniqueNoPesananArray = array_unique($noPesananArray);
            
            // Split each unique "No. Pesanan" value into an array of words
            $splitNoPesananArray = [];
            
            
            
            

            // Split, extract text, and upload each page as a separate file
                foreach ($uniqueNoPesananArray as $noPesanan) {
                    $words = explode(" ", $noPesanan);
                    $splitNoPesananArray[] = $words;
                //   $new_pdf = new Fpdi;
        
                //     // for($i = 20; $i <= 200; $i++){
                //     $new_pdf->AddPage();
                //     $new_pdf->setSourceFile($pdfFilePath);
                //     $new_pdf->useTemplate($new_pdf->importPage($chunkIndex));
                    // }
                    
                    // $new_pdf->Output(implode(" ", $words).'.pdf', "F");
                // $newPdf = new FPDF();
               
                // $newPdf->AddPage();
                // $newPdf->SetFont('Arial', '', 12);
                // $newPdf->MultiCell(0, 10, $text);
                // $outputPdfFile =  implode(" ", $words).'.pdf';
                // // Save the new PDF to the uploads folder
                // $newPdf->Output('./././assets/uploads/' . $outputPdfFile, 'F');
               
                	$noPesananArraySplitted = [
                	    'pdf_file_name' =>  './././assets/uploads/' . implode(" ", $words) . '.png',
                		'no_pesanan' => implode(" ", $words)
                	];
                	$insert = $this->db->insert("pesanan_pdf", $noPesananArraySplitted);
                	 
                }
                
                var_dump($splitNoPesananArray);
             $imagick = new \Imagick();

                // Set the resolution for the output images (adjust as needed)
                $imagick->setResolution(300, 300);
    
                // Read the input PDF file
                $imagick->readImage($pdfFilePath);
    
                // Loop through each page and convert to an image
                foreach ($imagick as $page_num => $page) {
                         $page->setImageFormat('png');
                    echo $splitNoPesananArray[$page_num][0];
                    // Save the image to the output directory
                    $output_file_path = './././assets/uploads/' . $splitNoPesananArray[$page_num][0] . '.png';
                    $page->writeImage($output_file_path);
                    // Set the image format (e.g., PNG, JPEG, GIF)
                   
                }
                
    
                // Destroy the Imagick object
                $imagick->destroy();
               
            
            
            	$msg = '';
        		if($insert){
        			$msg = true;
        			$this->session->set_userdata('msg_item', $msg);
        		}
        		
                redirect('adm/imports/');
            // Display or further process the extracted unique "No. Pesanan" values split into arrays of words
            // foreach ($splitNoPesananArray as $wordsArray) {
            // 	$noPesananArraySplitted[] = [
            // 		'no_pesanan' => $wordsArray
            // 	];
                
            // }
            // echo json_encode($noPesananArraySplitted);




			// echo $trackingNumber;
            //  echo nl2br($text);
            // $this->load->view('pdf_text_view', $data);
        }
    }
    
 private function splitAndExtractText($pdf, $pdfFilePath, $totalPages)
{
    $pages = $pdf->getPages();
    $chunkSize = 1; // Split into individual pages
    $chunkIndex = 1;
$parser = new Parser();
    while (count($pages) > 0) {
        // Extract the next page
        $page = array_shift($pages);

        // Extract text from the page
        $text = '';
        /** @var Page $page */
        $text .= $page->getText();
        

        // Save the text content to a text file
        // $outputTextFile = 'text_chunk_' . $chunkIndex . '.txt';
        // file_put_contents($outputTextFile, $text);

        // Create a new PDF object for the page
        // $newPdf = $parser->getFactory()->newPdf();
        // $newPdf->addPage($page);

        // Save the new PDF to the uploads folder
        
       

        // Increment the chunk index
        $chunkIndex++;
    }
}
    
     
    

	function isEmptyRow($row)
	{
		foreach ($row as $cell) {
			if (null !== $cell) return false;
		}
		return true;
	}
}
