<?php

/**
 * Report PPN Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
require_once APPPATH."libraries/BaseController.php";
use libraries\BaseController;

class Report extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Report_model');
		$this->load->model('Selling_orders_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{

		// echo logged_user('division');

		// die();
		$data['content_title']    = 'Laporan Penjualan';
		$data['dropshipper_data'] = $this->Report_model->get_dropshipper()->result();
		$data['courier_data']     = $this->Report_model->get_courier()->result();
		$data['item_data']        = $this->Report_model->get_item()->result();

		$this->twiggy_display('adm/report/index', $data);
	}
	public function index2()
	{

		// echo logged_user('division');

		// die();
		$data['content_title']    = 'Laporan Penjualan';
		$data['dropshipper_data'] = $this->Report_model->get_dropshipper()->result();
		$data['courier_data']     = $this->Report_model->get_courier()->result();
		$data['item_data']        = $this->Report_model->get_item()->result();

		$this->twiggy_display('adm/report/index2', $data);
	}

	public function get_data()
	{
		$date_1      = $this->input->post("date_1");
		$date_2      = $this->input->post("date_2");
		$dropshipper = $this->input->post("dropshipper");
		$courier     = $this->input->post("courier");
		$item        = $this->input->post("item");
		$val         = $this->input->post("val");

		$data  = [];
		$where = [];
		$total_outcome = 0;

		if (isset($date_1) && $date_1 != '') {
			$where['selling_order_header_date >='] = change_format_date($date_1);
		}
		if (isset($date_2) && $date_2 != '') {
			$where['selling_order_header_date <='] = change_format_date($date_2);
		}
// 		if (isset($dropshipper) && $dropshipper != '' && $dropshipper != '- Pilih -') {
// 			$where['dropshipper'] = $dropshipper;
// 		}
// 		if (isset($courier) && $courier != '' && $courier != '- Pilih -') {
// 			$where['courier'] = $courier;
// 		}
		if (isset($item) && $item != '' && $item != '- Pilih -') {
			$where['selling_order_detail_item_name'] = $item;
		}
// 		if (logged_user('role') != 1) {
// 			$where['a.division'] = logged_user('division');
// 		}

        if ($val == "laba") {
			$this->getLaba($where);
		}
        if ($val == "rekap_grup") {
			$this->getGroupRecap($where);
		}
		if ($val == "penjualan") {
			$this->getSales($where);
		}
			if ($val == "rekappenjualan") {
			$this->getRekapSales($where);
		}

		if ($val == "rekap_barang") {
			$this->getItemRecap($where);
		}

		if ($val == "surat_jalan") {
			$this->getSuratJalan($where);
		}

		if ($val == "rekap_dropshipper") {
			$this->getRekapDropshipper($where);
		}

		if ($val == "penjualan_dropshipper") {
			$this->getPenjualanDropshipper($where);
		}

		if ($val == "rekap_tipe") {
			$this->getRekapTipe($where);
		}
	}

	public function getSalesBackup($where)
	{
		$get_data = $this->Report_model->get_sales_detail($where, 'selling_order_detail_header_id asc, selling_order_header_number')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'date'        => change_format_date($get_row->selling_order_header_date, 'd/m/Y'),
					'number'      => $get_row->selling_order_header_number,
					'item'        => $get_row->	selling_order_detail_item_name,
					'unit'       => ($get_row->selling_order_detail_large_unit),
					'price'       => number_format($get_row->selling_order_detail_large_unit_price),
					'quantity'    => number_format($get_row->selling_order_detail_large_unit_quantity),
					'amount'      => number_format($get_row->selling_order_detail_total),
					'dropshipper' => $get_row->customer_name,
					'courier'     => "",
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
				'grand_total' => number_format(0),
			'total_transaksi' => number_format(0)
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
	
	public function getLaba($where){
	    $get_data    = $this->Selling_orders_model->purchaseorder_detail_advance($where, "selling_order_header_date ASC, selling_order_header_number", 'selling_order_header_id')->result();
		$grand_total = 0;
		$total_modal = 0;
        $total_laba = 0;
        $total = 0;
        $qty = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{	
			    
			 //   if($get_row->selling_order_header_number != null){
			        
			    

				$a = 0;
				$selling_total = ($get_row->selling_order_header_grand_total - $get_row->selling_order_header_ppn_total);
				if(isset($item) && $item != '' && $item != '(Semua)')
				{
					$selling_total = $a += ($get_row->selling_order_detail_result_large + $get_row->selling_order_detail_result_medium + $get_row->selling_order_detail_result_small);
				}
				
				// $where_detail = array('selling_order_header_id' => $get_row->selling_order_header_id);
				$where['selling_order_header_id'] = $get_row->selling_order_header_id;
				$data[] = array(
					'selling_number' => $get_row->selling_order_header_number,
					'selling_total'  => number_format($get_row->selling_order_header_grand_total),
					'qty'  => number_format($this->Selling_orders_model->purchaseorder_detail_sum_qty2($where, "selling_order_header_date ASC, selling_order_header_number", 'selling_order_header_id')->row()->result),
					'modal'  => number_format($this->Selling_orders_model->purchaseorder_detail_sum_modal($where, "selling_order_header_date ASC, selling_order_header_number", 'selling_order_header_id')->row()->result),
					'laba'  => number_format($this->Selling_orders_model->purchaseorder_detail_sum_laba($where, "selling_order_header_date ASC, selling_order_header_number", 'selling_order_header_id')->row()->result),
				);

				
				$gdata_detail = $this->Selling_orders_model->purchaseorder_detail_advance('', '', '', $where)->result();
                

				$rowspan = 1;
				foreach ($gdata_detail as $key => $value) {

					$ppn_status       = $get_row->status_paid;
					$ppn_status_color = '';

					if($ppn_status == '1'){
						$faktur = $value->faktur_1;
					}
					if($ppn_status == '2'){
						$ppn_status_color = 'cl-success';
					}
					if($ppn_status == '3'){
						$ppn_status_color = 'cl-warning';
					}

					// $faktur = trim(($value->faktur_1 != "0" ? $value->faktur_1 : "")." ".($value->faktur_2 != "0" ? $value->faktur_2 : "")." ".($value->faktur_3 != "0" ? $value->faktur_3 : ""));
					// if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
					// {	
					// 	if($ppn == '1'){
					// 		$faktur = $value->faktur_1;
					// 	}
					// 	if($ppn == '2'){
					// 		$faktur = $value->faktur_2;
					// 	}
					// 	if($ppn == '3'){
					// 		$faktur = $value->faktur_3;
					// 	}
					// }
                    // if($value->selling_order_header_number != null){
                        $data[$k]['detail'][$key] = array(	
						'no'               => $no,
						'detail_rowspan'   => $rowspan,
						'detail_line'      => $line,
						'selling_number'     => $value->selling_order_header_number,
						// 'faktur_number'    => $faktur,
				// 		'customer'         => $value->customer_name,
				// 		'faktur_1'         => ($value->faktur_1 == "0" ? "" : $value->faktur_1),
				// 		'faktur_2'         => ($value->faktur_2 == "0" ? "" : $value->faktur_2),
				// 		'faktur_3'         => ($value->faktur_3 == "0" ? "" : $value->faktur_3),
						'selling_date'       => change_format_date($value->selling_order_header_date, 'd/m/Y'),
						'item_name'        => $value->selling_order_detail_item_name,
						'lg_unit'          => ($value->selling_order_detail_large_unit_quantity  > 0 ? $value->selling_order_detail_large_unit : ''),
						'lg_unit_qty'      => ($value->selling_order_detail_large_unit_quantity  > 0 ? to_decimal($value->selling_order_detail_large_unit_quantity) : ''),
						'lg_unit_prc'      => ($value->selling_order_detail_large_unit_quantity  > 0 ? number_format($value->selling_order_detail_large_unit_price) : ''),
				// 		'md_unit'          => ($value->selling_order_detail_medium_unit_quantity > 0 ? $value->selling_order_detail_medium_unit : ''),
				// 		'md_unit_qty'      => ($value->selling_order_detail_medium_unit_quantity > 0 ? to_decimal($value->selling_order_detail_medium_unit_quantity) : ''),
				// 		'md_unit_prc'      => ($value->selling_order_detail_medium_unit_quantity > 0 ? number_format($value->selling_order_detail_medium_unit_price) : ''),
				// 		'sm_unit'          => ($value->selling_order_detail_small_unit_quantity  > 0 ? $value->selling_order_detail_small_unit : ''),
				// 		'sm_unit_qty'      => ($value->selling_order_detail_small_unit_quantity  > 0 ? to_decimal($value->selling_order_detail_small_unit_quantity) : ''),
				// 		'sm_unit_prc'      => ($value->selling_order_detail_small_unit_quantity  > 0 ? number_format($value->selling_order_detail_small_unit_price) : ''),
						'stock'			  => rtrim($value->selling_order_detail_large_unit . " " . to_decimal($value->selling_order_detail_large_unit_quantity) . ", " . $value->selling_order_detail_medium_unit . " " . to_decimal($value->selling_order_detail_medium_unit_quantity) . ", " . $value->selling_order_detail_small_unit . " " . to_decimal($value->selling_order_detail_small_unit_quantity), ", "),
						'ppn_status_color' => $ppn_status_color,
						'discount'            => $value->selling_order_detail_discount_percentage,
						'discount_price'            => number_format($value->selling_order_detail_discount_total),
						'modal'                     => number_format($value->selling_order_detail_large_unit_quantity * $value->selling_order_detail_large_unit_purchase_price),
						'laba'                     => number_format($value->selling_order_detail_total - ($value->selling_order_detail_large_unit_quantity * $value->selling_order_detail_large_unit_purchase_price)),
						'total'            => number_format($value->selling_order_detail_total),
						// 'total'            => number_format($value->selling_order_detail_total),
						// 'status' => $value->status_paid,
				// 		'is_hold'			 => ($value->is_hold == 1 ? 'bg-warning' : '')
					);
					$rowspan++;
					$line++;
                    $total_modal +=$value->selling_order_detail_large_unit_quantity * $value->selling_order_detail_large_unit_purchase_price;
                    $total_laba += $value->selling_order_detail_total - ($value->selling_order_detail_large_unit_quantity * $value->selling_order_detail_large_unit_purchase_price);
                    // $total += 
					$grand_total += ($value->selling_order_detail_large_unit_quantity * $value->selling_order_detail_large_unit_price) + ($value->selling_order_detail_medium_unit_quantity * $value->selling_order_detail_medium_unit_price) + ($value->selling_order_detail_small_unit_quantity * $value->selling_order_detail_small_unit_price);
                    // }
					
					// $total_all_tunai    += $tunai;
					// $total_all_transfer += $transfer;
					// $total_all_method   += $t_all;
					
				}
				$total += $get_row->selling_order_header_grand_total;
				$qty += $this->Selling_orders_model->purchaseorder_detail_sum_qty2($where, "selling_order_header_date ASC, selling_order_header_number", 'selling_order_header_id')->row()->result;
				$no++;
			 //   }
			}
		}
		
		$response = [
			'data'         => $data,
				'grand_total' => number_format($grand_total),
				'total_modal' => number_format($total_modal),
				'total_laba' => number_format($total_laba),
				'total' => number_format($total),
				'qty2' => number_format($qty)
// 			'total_transaksi' => number_format(0)
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
	
	public function getSales($where){
	    $get_data    = $this->Selling_orders_model->purchaseorder_detail_advance($where, "selling_order_header_date ASC, selling_order_header_number", 'selling_order_header_id')->result();
		$grand_total = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{	
			    
			 //   if($get_row->selling_order_header_number != null){
			        
			    

				$a = 0;
				$selling_total = ($get_row->selling_order_header_grand_total - $get_row->selling_order_header_ppn_total);
				if(isset($item) && $item != '' && $item != '(Semua)')
				{
					$selling_total = $a += ($get_row->selling_order_detail_result_large + $get_row->selling_order_detail_result_medium + $get_row->selling_order_detail_result_small);
				}
				
				// $where_detail = array('selling_order_header_id' => $get_row->selling_order_header_id);
				$where['selling_order_header_id'] = $get_row->selling_order_header_id;
				$data[] = array(
					'selling_number' => $get_row->selling_order_header_number,
					'selling_total'  => number_format($get_row->selling_order_header_grand_total),
				);

				
				$gdata_detail = $this->Selling_orders_model->purchaseorder_detail_advance('', '', '', $where)->result();
                

				$rowspan = 1;
				foreach ($gdata_detail as $key => $value) {

					$ppn_status       = $get_row->status_paid;
					$ppn_status_color = '';

					if($ppn_status == '1'){
						$faktur = $value->faktur_1;
					}
					if($ppn_status == '2'){
						$ppn_status_color = 'cl-success';
					}
					if($ppn_status == '3'){
						$ppn_status_color = 'cl-warning';
					}

					// $faktur = trim(($value->faktur_1 != "0" ? $value->faktur_1 : "")." ".($value->faktur_2 != "0" ? $value->faktur_2 : "")." ".($value->faktur_3 != "0" ? $value->faktur_3 : ""));
					// if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
					// {	
					// 	if($ppn == '1'){
					// 		$faktur = $value->faktur_1;
					// 	}
					// 	if($ppn == '2'){
					// 		$faktur = $value->faktur_2;
					// 	}
					// 	if($ppn == '3'){
					// 		$faktur = $value->faktur_3;
					// 	}
					// }
                    // if($value->selling_order_header_number != null){
                        $data[$k]['detail'][$key] = array(	
						'no'               => $no,
						'detail_rowspan'   => $rowspan,
						'detail_line'      => $line,
						'selling_number'     => $value->selling_order_header_number,
						// 'faktur_number'    => $faktur,
				// 		'customer'         => $value->customer_name,
				// 		'faktur_1'         => ($value->faktur_1 == "0" ? "" : $value->faktur_1),
				// 		'faktur_2'         => ($value->faktur_2 == "0" ? "" : $value->faktur_2),
				// 		'faktur_3'         => ($value->faktur_3 == "0" ? "" : $value->faktur_3),
						'selling_date'       => change_format_date($value->selling_order_header_date, 'd/m/Y'),
						'item_name'        => $value->selling_order_detail_item_name,
						'lg_unit'          => ($value->selling_order_detail_large_unit_quantity  > 0 ? $value->selling_order_detail_large_unit : ''),
						'lg_unit_qty'      => ($value->selling_order_detail_large_unit_quantity  > 0 ? to_decimal($value->selling_order_detail_large_unit_quantity) : ''),
						'lg_unit_prc'      => ($value->selling_order_detail_large_unit_quantity  > 0 ? number_format($value->selling_order_detail_large_unit_price) : ''),
				// 		'md_unit'          => ($value->selling_order_detail_medium_unit_quantity > 0 ? $value->selling_order_detail_medium_unit : ''),
				// 		'md_unit_qty'      => ($value->selling_order_detail_medium_unit_quantity > 0 ? to_decimal($value->selling_order_detail_medium_unit_quantity) : ''),
				// 		'md_unit_prc'      => ($value->selling_order_detail_medium_unit_quantity > 0 ? number_format($value->selling_order_detail_medium_unit_price) : ''),
				// 		'sm_unit'          => ($value->selling_order_detail_small_unit_quantity  > 0 ? $value->selling_order_detail_small_unit : ''),
				// 		'sm_unit_qty'      => ($value->selling_order_detail_small_unit_quantity  > 0 ? to_decimal($value->selling_order_detail_small_unit_quantity) : ''),
				// 		'sm_unit_prc'      => ($value->selling_order_detail_small_unit_quantity  > 0 ? number_format($value->selling_order_detail_small_unit_price) : ''),
						'stock'			  => rtrim($value->selling_order_detail_large_unit . " " . to_decimal($value->selling_order_detail_large_unit_quantity) . ", " . $value->selling_order_detail_medium_unit . " " . to_decimal($value->selling_order_detail_medium_unit_quantity) . ", " . $value->selling_order_detail_small_unit . " " . to_decimal($value->selling_order_detail_small_unit_quantity), ", "),
						'ppn_status_color' => $ppn_status_color,
						'discount'            => $value->selling_order_detail_discount_percentage,
						'discount_price'            => number_format($value->selling_order_detail_discount_total),
						'total'            => number_format($value->selling_order_detail_total),
						'username'     => $value->username,
						// 'total'            => number_format($value->selling_order_detail_total),
						// 'status' => $value->status_paid,
				// 		'is_hold'			 => ($value->is_hold == 1 ? 'bg-warning' : '')
					);
					$rowspan++;
					$line++;

					$grand_total += ($value->selling_order_detail_large_unit_quantity * $value->selling_order_detail_large_unit_price) + ($value->selling_order_detail_medium_unit_quantity * $value->selling_order_detail_medium_unit_price) + ($value->selling_order_detail_small_unit_quantity * $value->selling_order_detail_small_unit_price);
                    // }
					
					// $total_all_tunai    += $tunai;
					// $total_all_transfer += $transfer;
					// $total_all_method   += $t_all;
					
				}
				$no++;
			 //   }
			}
		}
		
		$response = [
			'data'         => $data,
				'grand_total' => number_format($grand_total),
// 			'total_transaksi' => number_format(0)
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
	
	public function getRekapSales($where)
	{
		$get_data = $this->Report_model->get_sales_header($where, 'selling_order_header_id asc, selling_order_header_number')->result();
        $grand_total = 0;
		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'          => $no,
					'date'        => change_format_date($get_row->selling_order_header_date, 'd/m/Y'),
					'number'      => $get_row->selling_order_header_number,
					'customer'      => $get_row->customer_name,
					'status'       => $get_row->status,
					'subtotal'       => number_format($get_row->selling_order_header_sub_total),
					'discount'        => number_format($get_row->selling_order_header_discount),
					'discount2'        => number_format($get_row->selling_order_header_discount2),
					'total'       => number_format($get_row->selling_order_header_grand_total),
					'username'     => $get_row->username,
				);
				$grand_total += $get_row->selling_order_header_grand_total;
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'grand_total' => number_format($grand_total),
			'total_transaksi' => number_format(count($get_data))
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getItemRecap($where)
	{
		$get_data = $this->Report_model->get_item_recap($where, 'selling_order_detail_item_name asc')->result();
        $total_qty = 0;
		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'code'     => $get_row->item_code,
					'name'     => $get_row->selling_order_detail_item_name,
					'quantity' => number_format($get_row->total),
				);
				$total_qty += $get_row->total;
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'total_qty' => $total_qty
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
	public function getGroupRecap($where)
	{
		$get_data = $this->Report_model->get_group_recap($where, 'group_name asc')->result();
        $total_qty = 0;
		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
				// 	'code'     => $get_row->item_code,
					'grup'     => $get_row->group_name,
					'quantity' => number_format($get_row->total),
				);
				$total_qty += $get_row->total;
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'total_qty' => $total_qty
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getSuratJalan($where)
	{
		$get_data = $this->Report_model->get_surat_jalan($where, 'courier asc')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'name'     => $get_row->courier,
					'quantity' => number_format($get_row->total),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getRekapDropshipper($where)
	{
		$get_data = $this->Report_model->get_rekap_dropshipper($where, 'dropshipper asc')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'name'     => $get_row->dropshipper,
					'quantity' => number_format($get_row->qty),
					'total' => number_format($get_row->total),
					'gt' => number_format($get_row->qty * $get_row->total),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getPenjualanDropshipper($where)
	{
		$get_data = $this->Report_model->get_sales_detail($where, 'header_id asc, number')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			$ubah_id = 0;
			foreach ($get_data as $get_row) {

				if ($get_row->header_id == $ubah_id) {
					$ubah_id = "UBAH";
				}

				$ttl = ($ubah_id === "UBAH" ? "" : number_format($this->Report_model->get_sum_ttl_by_header_id(array('header_id' => $get_row->header_id))->row()->total));
				$data[] = array(
					'no'            => $no,
					'date'          => change_format_date($get_row->date, 'd/m/Y'),
					'number'        => $get_row->number,
					'number_order'  => $get_row->number_order,
					'customer_name' => $get_row->customer_name,
					'item'          => $get_row->item_name,
					'price'         => number_format($get_row->price),
					'quantity'      => number_format($get_row->quantity),
					'amount'        => number_format($get_row->price * $get_row->quantity),
					'ubah_id'       => $ubah_id,
					'tll'           => $ttl,
					'dropshipper'   => $get_row->dropshipper,
					'courier'       => $get_row->courier,
				);
				$no++;
				$ubah_id = $get_row->header_id;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}

	public function getRekapTipe($where)
	{
		$get_data = $this->Report_model->get_rekap_tipe($where, 'type_name asc')->result();

		$data = [];
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'       => $no,
					'name'     => $get_row->type_name,
					'quantity' => number_format($get_row->qty),
					'total'    => number_format($get_row->harga),
					'gt'       => number_format($get_row->jumlah),
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			// 'date_1'       => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'       => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
		];

		output_json($response);
	}
}
