<?php

/**
 * Dashboards Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Report_purchase_model extends Model
{

	public function get_supplier()
	{
		$sql = "
		SELECT supplier_name
				FROM
				purchase_header
				GROUP BY supplier_name
				ORDER BY supplier_name asc
		";

		return $this->db->query($sql);
	}

	public function get_group()
	{
		$sql = "
		SELECT *
				FROM
				master_groups
		";

		return $this->db->query($sql);
	}

	public function get_item()
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'inner');
		$sql->join('master_types c', 'c.type_id = a.item_id', 'inner');
		$sql->join('master_colors d', 'd.color_id = a.item_color_id', 'inner');
		$sql->join('master_sizes e', 'e.size_id = a.item_size_id', 'inner');

		$sql->order_by('item_name');

		$get = $sql->get();

		return $get;
	}

	public function get_purchase_detail($where = '', $order = '',$group_by = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_detail a');
		$sql->join('purchase_header b', 'b.id = a.header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.item_id', 'inner');
		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}
		
		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_item_recap($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(quantity) as total');
		$sql->from('purchase_detail a');
		$sql->join('purchase_header b', 'b.id = a.header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.item_id', 'inner');
		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('a.item_name');

		$get = $sql->get();

		return $get;
	}

	public function get_type_recap($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(quantity) as qty_total, SUM(quantity * price) as amount_total');
		$sql->from('purchase_detail a');
		$sql->join('purchase_header b', 'b.id = a.header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.item_id', 'inner');
		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('e.type_id');

		$get = $sql->get();

		return $get;
	}

	public function get_group_recap($where = '', $order = '')
	{
		$sql = $this->db;

		$sql->select('*, SUM(quantity) as qty_total, SUM(quantity * price) as amount_total');
		$sql->from('purchase_detail a');
		$sql->join('purchase_header b', 'b.id = a.header_id', 'inner');
		$sql->join('master_items c', 'c.item_id = a.item_id', 'inner');
		$sql->join('master_groups d', 'd.group_id = c.item_group_id', 'inner');
		$sql->join('master_types e', 'e.type_id = c.item_type_id', 'inner');


		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$sql->group_by('d.group_id');

		$get = $sql->get();

		return $get;
	}
}
