
<?php
/**
 * Report Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_sales_orders extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Sales_returns_model');
		
		$this->load->model('Customers_model');
		$this->load->model('Users_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Penjualan';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['user_data'] = $this->Users_model->get_data_advance()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_orders/index', $data);
	}
	
	public function retur()
 	{	
        $data['content_title'] = 'Laporan Penjualan Omset Karyawan';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['user_data'] = $this->Users_model->get_data_advance()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_orders/potong', $data);
	}
	public function rekap()
 	{	
        $data['content_title'] = 'Laporan Penjualan Rekap';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['user_data'] = $this->Users_model->get_data_advance()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_orders/rekap', $data);
	}
    
    public function export()
 	{	
        $data['content_title'] = 'CoreTax';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_orders/export', $data);
	}
	
	public function get_data_export()
	{	
	    	$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		 $data  = [];
		$where = [];
		$order = ("printed_date ASC, sales_order_header_number");

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
// 		if(isset($item) && $item != '' && $item != '(Semua)')
// 		{
// 			$where['sales_order_detail_item_id'] = $item;
// 		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		// $order = "is_hold DESC";
// 		$order = "is_hold DESC, sales_order_header_date DESC, sales_order_header_number DESC";
		$get_data = $this->Sales_orders_model->salesorder_detail_advanced_sum($where, $order,'sales_order_header_id')->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
				$is_hold = ($get_row->is_hold == 0 ? '<i class="fas fa-circle text-success"></i>' : '<i class="fas fa-circle text-warning"></i>');
                if($get_row->sales_order_header_id != null){
                    $data[] = array(
					'no'          => $no,
					'id'          => $get_row->sales_order_header_id,
					'number'      => $get_row->sales_order_header_number,
					'date'        => indonesian_date($get_row->sales_order_header_date),
					'faktur'      => $get_row->sales_order_header_number,
					'date_paid'   => indonesian_date($get_row->printed_date),
					'customer'    => $get_row->customer_name,
					'npwp'    => $get_row->customer_npwp,
					'nik'    => $get_row->customer_ktp,
					'grand_total' => number_format($get_row->result),
					'description' => $get_row->sales_order_header_description,
					'is_hold'     => $is_hold,
				);
				$no++;
                }
				
			}
		}
		
		$this->session->set_userdata('ppn', $ppn);

		$response = [
			// 'date_1'             => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'             => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data' => $data,

		];

		output_json($response);
	}
	
	
    
	public function get_data_detail()
	{	
		$customer = $this->input->post("customer");
		$user = $this->input->post("user");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("printed_date ASC, sales_order_header_number");
        
        if(isset($user) && $user != '' && $user != '(Semua)')
		{
			$where['sales_order_header_user_id'] = $user;
		}
        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_order_header_date <='] = change_format_date($todate);
		}
		
		$get_data    = $this->Sales_orders_model->salesorder_detail_advance($where, $order, 'sales_order_header_id')->result();
		$grand_total = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{	

				$a = 0;
				$sales_total = ($get_row->sales_order_header_grand_total - $get_row->sales_order_header_ppn_total);
				if(isset($item) && $item != '' && $item != '(Semua)')
				{
					$sales_total = $a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small);
				}
				
				// $where_detail = array('sales_order_header_id' => $get_row->sales_order_header_id);
				$where['sales_order_header_id'] = $get_row->sales_order_header_id;
				$data[] = array(
					'sales_number' => $get_row->sales_order_header_number,
					'sales_total'  => number_format($get_row->sales_order_header_grand_total),
				);

				
				$gdata_detail = $this->Sales_orders_model->salesorder_detail_advance('', '', '', $where)->result();
                

				$rowspan = 1;
				foreach ($gdata_detail as $key => $value) {

					$ppn_status       = $get_row->sales_order_detail_ppn_status;
					$ppn_status_color = '';

					if($ppn_status == '1'){
						$faktur = $value->faktur_1;
					}
					if($ppn_status == '2'){
						$ppn_status_color = 'cl-success';
					}
					if($ppn_status == '3'){
						$ppn_status_color = 'cl-warning';
					}

					$faktur = trim(($value->faktur_1 != "0" ? $value->faktur_1 : "")." ".($value->faktur_2 != "0" ? $value->faktur_2 : "")." ".($value->faktur_3 != "0" ? $value->faktur_3 : ""));
					if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
					{	
						if($ppn == '1'){
							$faktur = $value->faktur_1;
						}
						if($ppn == '2'){
							$faktur = $value->faktur_2;
						}
						if($ppn == '3'){
							$faktur = $value->faktur_3;
						}
					}

					$data[$k]['detail'][$key] = array(	
						'no'               => $no,
						'detail_rowspan'   => $rowspan,
						'detail_line'      => $line,
						'sales_number'     => $value->sales_order_header_number,
						'faktur_number'    => $faktur,
						'customer'         => $value->customer_name,
						'faktur_1'         => ($value->faktur_1 == "0" ? "" : $value->faktur_1),
						'faktur_2'         => ($value->faktur_2 == "0" ? "" : $value->faktur_2),
						'faktur_3'         => ($value->faktur_3 == "0" ? "" : $value->faktur_3),
						'sales_date'       => change_format_date($value->printed_date, 'd/m/Y'),
						'item_name'        => $value->sales_order_detail_item_name,
						'lg_unit'          => ($value->sales_order_detail_large_unit_quantity  > 0 ? $value->sales_order_detail_large_unit : ''),
						'lg_unit_qty'      => ($value->sales_order_detail_large_unit_quantity  > 0 ? to_decimal($value->sales_order_detail_large_unit_quantity) : ''),
						'lg_unit_prc'      => ($value->sales_order_detail_large_unit_quantity  > 0 ? number_format($value->sales_order_detail_large_unit_price + $value->sales_order_detail_large_unit_discount) : ''),
						'md_unit'          => ($value->sales_order_detail_medium_unit_quantity > 0 ? $value->sales_order_detail_medium_unit : ''),
						'md_unit_qty'      => ($value->sales_order_detail_medium_unit_quantity > 0 ? to_decimal($value->sales_order_detail_medium_unit_quantity) : ''),
						'md_unit_prc'      => ($value->sales_order_detail_medium_unit_quantity > 0 ? number_format($value->sales_order_detail_medium_unit_price + $value->sales_order_detail_medium_unit_discount) : ''),
						'sm_unit'          => ($value->sales_order_detail_small_unit_quantity  > 0 ? $value->sales_order_detail_small_unit : ''),
						'sm_unit_qty'      => ($value->sales_order_detail_small_unit_quantity  > 0 ? to_decimal($value->sales_order_detail_small_unit_quantity) : ''),
						'sm_unit_prc'      => ($value->sales_order_detail_small_unit_quantity  > 0 ? number_format($value->sales_order_detail_small_unit_price + $value->sales_order_detail_small_unit_discount) : ''),
						'ppn_status_color' => $ppn_status_color,
				// 		'total'            => number_format($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small),
			        	'discount'            => number_format($value->sales_order_detail_discount_total),
						'total'            => number_format($value->sales_order_detail_total),
						'status' => $value->sales_order_detail_ppn_status,
						'is_hold'			 => ($value->is_hold == 1 ? 'bg-warning' : '')
					);
					$rowspan++;
					$line++;

				// 	$grand_total += $value->sales_order_detail_total;
					// $total_all_tunai    += $tunai;
					// $total_all_transfer += $transfer;
					// $total_all_method   += $t_all;
					
				}
				$grand_total += $get_row->sales_order_header_grand_total;
				$no++;
			}
		}

		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('ppn', $ppn);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		$response = [
			// 'date_1'             => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'             => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data' => $data,
			'grand_total' => number_format($grand_total),
			'total_transaksi' => number_format(count($get_data))
		];

		output_json($response);
	}
	
	public function get_data_detail_rekap()
	{	
		$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		$user = $this->input->post("user");


        $data  = [];
		$where = [];
		$order = ("printed_date ASC, sales_order_header_number");
        if(isset($user) && $user != '' && $user != '(Semua)')
		{
			$where['sales_order_header_user_id'] = $user;
		}
        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_order_header_date <='] = change_format_date($todate);
		}
		$where['is_hold'] = 0;
		
		$get_data    = $this->Sales_orders_model->salesorder_header($where, $order)->result();
		$grand_total = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	

			
				$data[] = array(
				    'no'               => $no,
					'sales_number' => $get_row->sales_order_header_number,
					'customer' => $get_row->customer_name,
					'salesman' => $get_row->sales_name,
					'sales_date' => $get_row->sales_order_header_date,
					'sales_total'  => number_format($get_row->sales_order_header_grand_total),
					'keterangan' => $get_row->sales_order_header_description,
					
				);
				$grand_total += $get_row->sales_order_header_grand_total;
				$no++;
			}
		}

		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('ppn', $ppn);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		$response = [
			// 'date_1'             => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'             => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data' => $data,
			'grand_total' => number_format($grand_total),
			'total_transaksi' => number_format(count($get_data))
		];

		output_json($response);
	}
	public function get_data_detail_potong()
	{	
		$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");
		$user = $this->input->post("user");


        $data  = [];
		$where = [];
		$order = ("printed_date ASC, sales_order_header_number");
        if(isset($user) && $user != '' && $user != '(Semua)')
		{
			$where['sales_order_header_user_id'] = $user;
		}
        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['sales_order_header_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['sales_order_header_date <='] = change_format_date($todate);
		}
		$where['is_hold'] = 0;
		
		$get_data    = $this->Sales_orders_model->salesorder_header($where, $order)->result();
		$grand_total = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $get_row)
			{	
                $total_retur = 0;
			    $get_data_retur    = $this->Sales_returns_model->salesreturn_header(array('sales_order_header_id' => $get_row->sales_order_header_id), '')->row();
			    if($get_data_retur){
			        $total_retur = $get_data_retur->sales_return_header_grand_total;
			    }
				$data[] = array(
				    'no'               => $no,
					'sales_number' => $get_row->sales_order_header_number,
					'customer' => $get_row->customer_name,
					'salesman' => $get_row->sales_name,
					'sales_date' => $get_row->sales_order_header_date,
					'sales_total'  => number_format($get_row->sales_order_header_grand_total),
					'sales_retur'  => number_format($total_retur),
					'sales_grand_total'  => number_format($get_row->sales_order_header_grand_total - $total_retur),
					'keterangan' => $get_row->sales_order_header_description,
					
				);
				$grand_total += $get_row->sales_order_header_grand_total - $total_retur;
				$no++;
			}
		}

		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('ppn', $ppn);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		$response = [
			// 'date_1'             => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'             => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data' => $data,
			'grand_total' => number_format($grand_total),
			'total_transaksi' => number_format(count($get_data))
		];

		output_json($response);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$item     = $this->session->userdata('item');
		$ppn      = $this->session->userdata('ppn');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order = ("printed_date ASC, sales_order_header_number");
		$customer_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		
		$get_data = $this->Sales_orders_model->salesorder_detail_advance($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PENJUALAN")
							   ->setSubject("PENJUALAN")
							   ->setDescription("PENJUALAN")
							   ->setKeywords("PENJUALAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_row_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5cb85c')
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Penjualan");
	    $excel->getActiveSheet()->mergeCells('A1:Q1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$fromdate_text." - ".$todate_text);

	    $excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');
		$excel->getActiveSheet()->mergeCells('D7:D8');
		$excel->getActiveSheet()->mergeCells('E7:E8');
		$excel->getActiveSheet()->mergeCells('F7:F8');

		$excel->getActiveSheet()->mergeCells('G7:J7');
		$excel->getActiveSheet()->mergeCells('K7:N7');
		$excel->getActiveSheet()->mergeCells('O7:R7');

		$excel->getActiveSheet()->mergeCells('S7:S8');
		$excel->getActiveSheet()->mergeCells('T7:T8');
		$excel->getActiveSheet()->mergeCells('U7:U8');
		$excel->getActiveSheet()->mergeCells('V7:V8');
		$excel->getActiveSheet()->mergeCells('W7:W8');
		$excel->getActiveSheet()->mergeCells('X7:X8');

	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "No.");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Nomor Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Nomor Faktur");
	    $excel->setActiveSheetIndex(0)->setCellValue('D7', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('E7', "Pelanggan");
	    $excel->setActiveSheetIndex(0)->setCellValue('F7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('G7', "Satuan Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('K7', "Satuan Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('O7', "Satuan Kecil");

		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('J8', "Harga Setelah Diskon");
		$excel->setActiveSheetIndex(0)->setCellValue('K8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('L8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('M8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('N8', "Harga Setelah Diskon");
		$excel->setActiveSheetIndex(0)->setCellValue('O8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('P8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('Q8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('R8', "Harga Setelah Diskon");

		$excel->setActiveSheetIndex(0)->setCellValue('S7', "Total Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('T7', "Total Harga Setelah PPN");
		$excel->setActiveSheetIndex(0)->setCellValue('U7', "Status");
		$excel->setActiveSheetIndex(0)->setCellValue('V7', "discoun");
// 		$excel->setActiveSheetIndex(0)->setCellValue('W7', "disc_medium");
// 		$excel->setActiveSheetIndex(0)->setCellValue('X7', "disc_small");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D7:D8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E7:E8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('F7:F8')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('G7:J7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K7:N7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('O7:R7')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('M8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('N8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('O8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('P8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('Q8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('R8')->applyFromArray($style_col);

	    $excel->getActiveSheet()->getStyle('S7:S8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('T7:T8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('U7:U8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('V7:V8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('W7:W8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('X7:X8')->applyFromArray($style_col);


	    $no = 0; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 9
		$numtrx = '';
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			if($numtrx != $get_row->sales_order_header_id){
				$no++;
			}
			$numtrx = $get_row->sales_order_header_id;

			$faktur = trim(($get_row->faktur_1 != "0" ? $get_row->faktur_1 : "")." ".($get_row->faktur_2 != "0" ? $get_row->faktur_2 : "")." ".($get_row->faktur_3 != "0" ? $get_row->faktur_3 : ""));
			if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
			{	
				if($ppn == '1'){
					$faktur = $get_row->faktur_1;
				}
				if($ppn == '2'){
					$faktur = $get_row->faktur_2;
				}
				if($ppn == '3'){
					$faktur = $get_row->faktur_3;
				}
			}
			
			$harga = $get_row->sales_order_detail_total / $get_row->sales_order_detail_large_unit_quantity;
			$ppn = $get_row->sales_order_detail_total * 11/100;
			
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $faktur);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, change_format_date($get_row->printed_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->sales_order_detail_item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? $get_row->sales_order_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? ($get_row->sales_order_detail_large_unit_price + $get_row->sales_order_detail_large_unit_discount) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? ($get_row->sales_order_detail_large_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? $get_row->sales_order_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? to_decimal($get_row->sales_order_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? ($get_row->sales_order_detail_medium_unit_price + $get_row->sales_order_detail_medium_unit_discount) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? ($get_row->sales_order_detail_medium_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? $get_row->sales_order_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('P'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('Q'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? ($get_row->sales_order_detail_small_unit_price + $get_row->sales_order_detail_small_unit_discount) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('R'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? ($get_row->sales_order_detail_small_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('S'.$numrow, ($get_row->sales_order_detail_total));
			$excel->setActiveSheetIndex(0)->setCellValue('T'.$numrow, ($get_row->sales_order_detail_total) - $get_row->sales_order_detail_ppn_total);
			// $excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, number_format($get_row->sales_order_detail_total));
			$excel->setActiveSheetIndex(0)->setCellValue('U'.$numrow, $get_row->sales_order_detail_ppn_status);
			$excel->setActiveSheetIndex(0)->setCellValue('V'.$numrow, $get_row->sales_order_detail_discount_total);
// 			$excel->setActiveSheetIndex(0)->setCellValue('W'.$numrow, $get_row->sales_order_detail_medium_unit_discount);
// 			$excel->setActiveSheetIndex(0)->setCellValue('X'.$numrow, $get_row->sales_order_detail_small_unit_discount);


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			$excel->getActiveSheet()->getStyle('A'.$numrow.':V'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			if($get_row->is_hold == '1'){
				$excel->getActiveSheet()->getStyle('A'.$numrow.':V'.$numrow)->applyFromArray($style_row_warning);
			}

			$excel->getActiveSheet()->getStyle('I'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('J'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('M'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('N'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('Q'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('R'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	 // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PENJUALAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PENJUALAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    ob_end_clean();
	    $write->save('php://output');
	}
	
	public function export_excel_rekap() {

		$customer = $this->session->userdata('customer');
		$item     = $this->session->userdata('item');
		$ppn      = $this->session->userdata('ppn');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order = ("printed_date ASC, sales_order_header_number");
		$customer_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		
		$get_data = $this->Sales_orders_model->salesorder_header($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PENJUALAN")
							   ->setSubject("PENJUALAN")
							   ->setDescription("PENJUALAN")
							   ->setKeywords("PENJUALAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_row_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5cb85c')
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Penjualan");
	    $excel->getActiveSheet()->mergeCells('A1:Q1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$fromdate_text." - ".$todate_text);

	    $excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');
		$excel->getActiveSheet()->mergeCells('D7:D8');
		$excel->getActiveSheet()->mergeCells('E7:E8');


	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "No.");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Nomor Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Sales");
	    $excel->setActiveSheetIndex(0)->setCellValue('D7', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('E7', "Pelanggan");
	    $excel->setActiveSheetIndex(0)->setCellValue('F7', "Total Harga");
	    $excel->setActiveSheetIndex(0)->setCellValue('G7', "Keterangan");
	  
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D7:D8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E7:E8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('F7:F8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('G7:G8')->applyFromArray($style_col);
		

	    $no = 0; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 9
		$numtrx = '';
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
		
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $get_row->sales_name);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, change_format_date($get_row->printed_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, ($get_row->sales_order_header_grand_total));
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, $get_row->sales_order_header_description);
		


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			$excel->getActiveSheet()->getStyle('A'.$numrow.':G'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			if($get_row->is_hold == '1'){
				$excel->getActiveSheet()->getStyle('A'.$numrow.':G'.$numrow)->applyFromArray($style_row_warning);
			}


	      	 // Tambah 1 setiap kali looping
	      	 $no++;
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PENJUALAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PENJUALAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    ob_end_clean();
	    $write->save('php://output');
	}
	
	public function generate_xml() {
	    ob_clean();
        $ids = $this->input->post('id'); // Array of selected IDs
        $ppn      = $this->session->userdata('ppn');

        if (empty($ids)) {
            show_error('No data selected for export.', 400);
            return;
        }
    
        // Fetch data from DB
        $this->db->select('*, 
    SUM(
        CASE 
            WHEN a.sales_order_detail_ppn_status = 2 THEN 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) * 1.11 
            ELSE 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) 
        END
    ) as result');
        $this->db->from('sales_order_details a');
		$this->db->join('sales_order_headers b', 'b.sales_order_header_id = a.sales_order_detail_header_id', 'left');
        // $this->db->from('sales_order_headers');
        $this->db->join('master_customers', 'master_customers.customer_id = b.sales_order_header_customer_id', 'left'); // Adjust based on relationship
        $this->db->where_in('b.sales_order_header_id', $ids);
        if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
		    $this->db->where('a.sales_order_detail_ppn_status', $ppn);
        }
        
        $this->db->order_by('b.printed_date', 'ASC');
        $this->db->group_by('b.sales_order_header_id');
        $query = $this->db->get();
    
        $sales_data = $query->result();
    
        // Group by printed_date
        $grouped_data = [];
        foreach ($sales_data as $data) {
            if (!isset($grouped_data[$data->printed_date])) {
                $grouped_data[$data->printed_date] = 0;
            }
            $grouped_data[$data->printed_date] += $data->result;
        }
    
        // Generate XML structure
        $xml_data = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><RetailInvoiceBulk xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="TaxInvoice.xsd"></RetailInvoiceBulk>');
    
        $xml_data->addChild('TIN', '0825402209403000');
        $xml_data->addChild('TaxPeriodMonth', '01');
        $xml_data->addChild('TaxPeriodYear', '2025');
    
        $listOfRetailInvoice = $xml_data->addChild('ListOfRetailInvoice');
    
        foreach ($grouped_data as $date => $total_sales) {
            if($ppn == 3){
                $taxBase = $total_sales ;
                $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
                $lnTaxBase = round($taxBase * 11 / 12, 0);
                $lnVAT = 0;
            }else{
                $taxBase = round($total_sales / 1.11, 1);
                $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
                $lnTaxBase = round($taxBase * 11 / 12, 0);
                $lnVAT = round($lnTaxBase * 0.12, 0);
            }
            
            

            $retailInvoice = $listOfRetailInvoice->addChild('RetailInvoice');
            $retailInvoice->addChild('TrxCode', 'Normal');
            $retailInvoice->addChild('BuyerName', '-');
            $retailInvoice->addChild('BuyerIdOpt', 'NIK');
            $retailInvoice->addChild('BuyerIdNumber', '0000000000000000');
            $retailInvoice->addChild('GoodServiceOpt', 'A');
            $retailInvoice->addChild('SerialNo', '0');
            $retailInvoice->addChild('TransactionDate', $date);
            $retailInvoice->addChild('TaxBaseSellingPrice', number_format($taxBase, 2, '.', ''));
            $retailInvoice->addChild('OtherTaxBaseSellingPrice', number_format($lnTaxBase, 2, '.', ''));
            $retailInvoice->addChild('VAT', number_format($lnVAT, 2, '.', ''));
            $retailInvoice->addChild('STLG', '0');
            $retailInvoice->addChild('Info', 'ok');
        }
    
        // Generate XML file
        $xml_content = $xml_data->asXML();
        $filename = 'RetailInvoice_' . date('Ymd_His') . '.xml';
    
        // Set headers for file download
        header('Content-Type: application/xml');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Content-Length: ' . strlen($xml_content));
        header('Pragma: no-cache');
        header('Expires: 0');
    
        echo $xml_content;

    }
    
    public function generate_xml_efaktur() {
        ob_clean();
        $ids = $this->input->post('id'); // Array of selected IDs
        $ppn      = $this->session->userdata('ppn');

        if (empty($ids)) {
            show_error('No data selected for export.', 400);
            return;
        }
    
        // Fetch data from DB
     
        // Generate XML structure
         // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $sheet = $objPHPExcel->getActiveSheet();
    
        // Set column headers
        $sheet->setCellValue('A1', 'FK');
        $sheet->setCellValue('A2', 'LT');
        $sheet->setCellValue('A3', 'OF');
        $sheet->setCellValue('B1', 'KD_JENIS_TRANSAKSI');
        $sheet->setCellValue('B2', 'NPWP');
        $sheet->setCellValue('B3', 'KODE_OBJEK');
        $sheet->setCellValue('C1', 'FG_PENGGANTI');
        $sheet->setCellValue('C2', 'NAMA');
        $sheet->setCellValue('C3', 'NAMA');
        $sheet->setCellValue('D1', 'NOMOR_FAKTUR');
        $sheet->setCellValue('D2', 'JALAN');
        $sheet->setCellValue('D3', 'HARGA_SATUAN');
        $sheet->setCellValue('E1', 'MASA_PAJAK');
        $sheet->setCellValue('E2', 'BLOK');
        $sheet->setCellValue('E3', 'JUMLAH_BAR');
        $sheet->setCellValue('F1', 'TAHUN_PAJAK');
        $sheet->setCellValue('F2', 'NOMOR');
        $sheet->setCellValue('F3', 'HARGA_TOTAL');
        $sheet->setCellValue('G1', 'TANGGAL_FA');
        $sheet->setCellValue('G2', 'RT');
        $sheet->setCellValue('G3', 'DISKON');
        $sheet->setCellValue('H1', 'NPWP');
        $sheet->setCellValue('H2', 'RW');
        $sheet->setCellValue('H3', 'DPP');
        $sheet->setCellValue('I1', 'NAMA');
        $sheet->setCellValue('I2', 'KECAMATAN');
        $sheet->setCellValue('I3', 'PPN');
        $sheet->setCellValue('J1', 'ALAMAT_LENGKAP');
        $sheet->setCellValue('J2', 'KELURAHAN');
        $sheet->setCellValue('J3', 'TARIF_PPNBM');
        $sheet->setCellValue('K1', 'JUMLAH_DPP');
        $sheet->setCellValue('K2', 'KABUPATEN');
        $sheet->setCellValue('K3', 'PPNBM');
        $sheet->setCellValue('L1', 'JUMLAH_PPN');
        $sheet->setCellValue('L2', 'PROPINSI');
        $sheet->setCellValue('L3', 'PROPINSI');
        $sheet->setCellValue('M1', 'JUMLAH_PPNBM');
        $sheet->setCellValue('M2', 'KODE_POS');
        $sheet->setCellValue('N1', 'ID_KETERNAGAN_TAMBAHAN');
        $sheet->setCellValue('N2', 'NOMOR_TELEPON');
        $sheet->setCellValue('O1', 'FG_UANG_MUKA');
        $sheet->setCellValue('P1', 'UANG_MUKA_DPP');
        $sheet->setCellValue('Q1', 'UANG_MUKA_PPN');
        $sheet->setCellValue('R1', 'UANG_MUKA_PPNBM');
        $sheet->setCellValue('S1', 'REFERENSI');
        $sheet->setCellValue('T1', 'KODE_DOKUMEN_PENDUKUNG');
    
        // Format header
        $sheet->getStyle("A1:T3")->getFont()->setBold(true);
        $sheet->getStyle("A1:T3")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        
        $totalTaxBase = 0;
        $totalOtherTaxBase = 0;
        $totalVAT = 0;
        // Fill data
        $row = 4;
        foreach($ids as $id){
            $get_data = $this->Sales_orders_model->salesorder_efaktur_sum(array('sales_order_header_id' => $id),'','sales_order_header_id')->row();
            $sheet->setCellValue('A' . $row, "FK");
            $sheet->setCellValue('B' . $row, "01");
            $sheet->setCellValue('C' . $row, "0");
            $sheet->setCellValue('D' . $row, "");
            $sheet->setCellValue('E' . $row, date('m', strtotime($get_data->sales_order_header_date)));
            $sheet->setCellValue('F' . $row, date('Y', strtotime($get_data->sales_order_header_date)));
            $sheet->setCellValue('G' . $row, change_format_date($get_data->sales_order_header_date, 'd/m/Y'));
            $sheet->setCellValue('H' . $row, "0000000000000000");
            $sheet->setCellValue('I' . $row, $get_data->customer_name);
            $sheet->setCellValue('J' . $row, $get_data->customer_address);
            // $ppn = round(($get_data->sales_order_header_grand_total/1.11)*11/100,0);
            $ppn = ($get_data->ppntotal);
            // $sheet->setCellValue('K' . $row, round($get_data->sales_order_header_grand_total - $ppn,0));
            $sheet->setCellValue('K' . $row, floor($get_data->grandtotal));
            $sheet->setCellValue('L' . $row, ($ppn));
            $sheet->setCellValue('M' . $row, "0");
            $sheet->setCellValue('N' . $row, "");
            $sheet->setCellValue('O' . $row, "");
            $sheet->setCellValue('P' . $row, "");
            $sheet->setCellValue('Q' . $row, "");
            $sheet->setCellValue('R' . $row, "");
            $sheet->setCellValue('S' . $row, $get_data->sales_order_header_number);
            $sheet->setCellValue('T' . $row, "");
            $row++;
            $get_data_detail = $this->Sales_orders_model->salesorder_detail(array('sales_order_detail_header_id ' => $id))->result();
            foreach($get_data_detail as $value){
                $sheet->setCellValue('A' . $row, "OF");
                $sheet->setCellValue('B' . $row, "01");
                $sheet->setCellValue('C' . $row, $value->sales_order_detail_item_name);
                $discount = $value->sales_order_detail_discount_total / $value->sales_order_detail_large_unit_quantity;
                $price = $value->sales_order_detail_large_unit_price - $discount;
                $ppn = (($price/1.11)*11/100);
                $sheet->setCellValue('D' . $row, round($price - $ppn));
                $sheet->setCellValue('E' . $row, $value->sales_order_detail_large_unit_quantity);
                $sheet->setCellValue('F' . $row, round(($price - $ppn) * $value->sales_order_detail_large_unit_quantity));
                $sheet->setCellValue('G' . $row, "0");
                $sheet->setCellValue('H' . $row, round(($price - $ppn) * $value->sales_order_detail_large_unit_quantity));
                $ppntotal = round((($price - $ppn) * $value->sales_order_detail_large_unit_quantity) * 11/100);
                $sheet->setCellValue('I' . $row, $ppntotal);
                $sheet->setCellValue('J' . $row, "0");
                $sheet->setCellValue('K' . $row, "0");
                $sheet->setCellValue('L' . $row, "0");
                $sheet->setCellValue('M' . $row, "0");
                $sheet->setCellValue('N' . $row, "");
                $sheet->setCellValue('O' . $row, "");
                $sheet->setCellValue('P' . $row, "");
                $sheet->setCellValue('Q' . $row, "");
                $sheet->setCellValue('R' . $row, "");
                $sheet->setCellValue('S' . $row, $get_data->sales_order_header_number);
                $sheet->setCellValue('T' . $row, "");
                $row++;
            }
            
        }

    
        // File name
        $filename = 'EFAKTUR_' . date('Ymd_His') . '.xlsx';
    
        // Set headers for file download
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
        ob_end_clean();
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');

    }
    
    public function generate_xml_excel() {
        ob_clean();
        $ids = $this->input->post('id'); // Array of selected IDs
        $ppn      = $this->session->userdata('ppn');

        if (empty($ids)) {
            show_error('No data selected for export.', 400);
            return;
        }
    
        // Fetch data from DB
        $this->db->select('*, 
    SUM(
        CASE 
            WHEN a.sales_order_detail_ppn_status = 2 THEN 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) * 1.11 
            ELSE 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) 
        END
    ) as result');
        $this->db->from('sales_order_details a');
		$this->db->join('sales_order_headers b', 'b.sales_order_header_id = a.sales_order_detail_header_id', 'left');
        // $this->db->from('sales_order_headers');
        $this->db->join('master_customers', 'master_customers.customer_id = b.sales_order_header_customer_id', 'left'); // Adjust based on relationship
        $this->db->where_in('b.sales_order_header_id', $ids);
        if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
		    $this->db->where('a.sales_order_detail_ppn_status', $ppn);
        }
        
        $this->db->order_by('b.printed_date', 'ASC');
        $this->db->group_by('b.sales_order_header_id');
        $query = $this->db->get();
    
        $sales_data = $query->result();
    
        // Group by printed_date
        $grouped_data = [];
        foreach ($sales_data as $data) {
            if (!isset($grouped_data[$data->printed_date])) {
                $grouped_data[$data->printed_date] = 0;
            }
            $grouped_data[$data->printed_date] += $data->result;
        }
    
        // Generate XML structure
         // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $sheet = $objPHPExcel->getActiveSheet();
    
        // Set column headers
        $sheet->setCellValue('A1', 'Transaction Date');
        $sheet->setCellValue('B1', 'Tax Base Selling Price');
        $sheet->setCellValue('C1', 'Other Tax Base Selling Price');
        $sheet->setCellValue('D1', 'VAT');
    
        // Format header
        $sheet->getStyle("A1:D1")->getFont()->setBold(true);
        $sheet->getStyle("A1:D1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $totalTaxBase = 0;
        $totalOtherTaxBase = 0;
        $totalVAT = 0;
        // Fill data
        $row = 2;
        foreach ($grouped_data as $date => $total_sales) {
            if ($ppn == 3) {
                $taxBase = $total_sales;
                $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
                $lnTaxBase = round($taxBase * 11 / 12, 0);
                $lnVAT = 0;
            } else {
                $taxBase = round($total_sales / 1.11, 1);
                $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
                $lnTaxBase = round($taxBase * 11 / 12, 0);
                $lnVAT = round($lnTaxBase * 0.12, 0);
            }
    
            $sheet->setCellValue('A' . $row, $date);
            $sheet->setCellValue('B' . $row, number_format($taxBase, 2, '.', ''));
            $sheet->setCellValue('C' . $row, number_format($lnTaxBase, 2, '.', ''));
            $sheet->setCellValue('D' . $row, number_format($lnVAT, 2, '.', ''));
            $totalTaxBase += $taxBase;
            $totalOtherTaxBase += $lnTaxBase;
            $totalVAT += $lnVAT;
            $row++;
        }
        
        $sheet->setCellValue('A' . $row, 'TOTAL');
        $sheet->setCellValue('B' . $row, number_format($totalTaxBase, 2, '.', ''));
        $sheet->setCellValue('C' . $row, number_format($totalOtherTaxBase, 2, '.', ''));
        $sheet->setCellValue('D' . $row, number_format($totalVAT, 2, '.', ''));
    
        // Auto-size columns
        foreach (range('A', 'D') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }
    
        // File name
        $filename = 'RetailInvoice_' . date('Ymd_His') . '.xlsx';
    
        // Set headers for file download
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
    
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');

    }
    
    public function generate_xml_header() {
        ob_clean();
        $ids = $this->input->post('id'); // Array of selected IDs
        $ppn      = $this->session->userdata('ppn');

        if (empty($ids)) {
            show_error('No data selected for export.', 400);
            return;
        }
    
        // Fetch data from DB
        $this->db->select('*, 
    SUM(
        CASE 
            WHEN a.sales_order_detail_ppn_status = 2 THEN 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) * 1.11 
            ELSE 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) 
        END
    ) as result');
        $this->db->from('sales_order_details a');
		$this->db->join('sales_order_headers b', 'b.sales_order_header_id = a.sales_order_detail_header_id', 'left');
        // $this->db->from('sales_order_headers');
        $this->db->join('master_customers', 'master_customers.customer_id = b.sales_order_header_customer_id', 'left'); // Adjust based on relationship
        $this->db->where_in('b.sales_order_header_id', $ids);
        if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
		    $this->db->where('a.sales_order_detail_ppn_status', $ppn);
        }
        
        $this->db->order_by('b.printed_date', 'ASC');
        $this->db->group_by('b.sales_order_header_id');
        $query = $this->db->get();
    
        $sales_data = $query->result();
    
        // Group by printed_date
        // $grouped_data = [];
        // foreach ($sales_data as $data) {
        //     if (!isset($grouped_data[$data->printed_date])) {
        //         $grouped_data[$data->printed_date] = 0;
        //     }
        //     $grouped_data[$data->printed_date] += $data->sales_order_header_grand_total;
        // }
    
        // Generate XML structure
        $xml_data = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><RetailInvoiceBulk xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="TaxInvoice.xsd"></RetailInvoiceBulk>');
    
        $xml_data->addChild('TIN', '0825402209403000');
        $xml_data->addChild('TaxPeriodMonth', '01');
        $xml_data->addChild('TaxPeriodYear', '2025');
    
        $listOfRetailInvoice = $xml_data->addChild('ListOfRetailInvoice');
    
        foreach ($sales_data as $data) {
            if($ppn == 3){
                $taxBase = round($data->result);
            $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
            $lnTaxBase = round($taxBase * 11 / 12, 0);
            $lnVAT = 0;
            }else{
                $taxBase = round($data->result / 1.11, 1);
            $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
            $lnTaxBase = round($taxBase * 11 / 12, 0);
            $lnVAT = round($lnTaxBase * 0.12, 0);
            }
            

            $retailInvoice = $listOfRetailInvoice->addChild('RetailInvoice');
            $retailInvoice->addChild('TrxCode', 'Normal');
            $retailInvoice->addChild('BuyerName', $data->customer_name);
            $retailInvoice->addChild('BuyerIdOpt', 'NIK');
            $retailInvoice->addChild('BuyerIdNumber', '0000000000000000');
            $retailInvoice->addChild('GoodServiceOpt', 'A');
            $retailInvoice->addChild('SerialNo', '0');
            $retailInvoice->addChild('TransactionDate', $data->sales_order_header_date);
            $retailInvoice->addChild('TaxBaseSellingPrice', number_format($taxBase, 2, '.', ''));
            $retailInvoice->addChild('OtherTaxBaseSellingPrice', number_format($lnTaxBase, 2, '.', ''));
            $retailInvoice->addChild('VAT', number_format($lnVAT, 2, '.', ''));
            $retailInvoice->addChild('STLG', '0');
            $retailInvoice->addChild('Info', 'ok');
        }
    
        // Generate XML file
        $xml_content = $xml_data->asXML();
        $filename = 'RetailInvoice_' . date('Ymd_His') . '.xml';
    
        // Set headers for file download
        header('Content-Type: application/xml');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Content-Length: ' . strlen($xml_content));
        header('Pragma: no-cache');
        header('Expires: 0');
    
        echo $xml_content;
    
        

    }
    
    public function generate_xml_header_excel() {
        ob_clean();
        $ids = $this->input->post('id'); // Array of selected IDs
        $ppn      = $this->session->userdata('ppn');

        if (empty($ids)) {
            show_error('No data selected for export.', 400);
            return;
        }
    
        // Fetch data from DB
        
        // $this->db->select('*,sum(sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) as result');
        $this->db->select('*, 
    SUM(
        CASE 
            WHEN a.sales_order_detail_ppn_status = 2 THEN 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) * 1.11 
            ELSE 
                (sales_order_detail_result_large + sales_order_detail_result_medium + sales_order_detail_result_small) 
        END
    ) as result');
        $this->db->from('sales_order_details a');
		$this->db->join('sales_order_headers b', 'b.sales_order_header_id = a.sales_order_detail_header_id', 'left');
        // $this->db->from('sales_order_headers');
        $this->db->join('master_customers', 'master_customers.customer_id = b.sales_order_header_customer_id', 'left'); // Adjust based on relationship
        $this->db->where_in('b.sales_order_header_id', $ids);
        if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
		    $this->db->where('a.sales_order_detail_ppn_status', $ppn);
        }
        
        $this->db->order_by('b.printed_date', 'ASC');
        $this->db->group_by('b.sales_order_header_id');
        $query = $this->db->get();
    
        $sales_data = $query->result();
    

    
        // Generate XML structure
         // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $sheet = $objPHPExcel->getActiveSheet();
    
        // Set column headers
        $sheet->setCellValue('A1', 'Buyer Name');
        $sheet->setCellValue('B1', 'Buyer Id Number');
        $sheet->setCellValue('C1', 'Transaction Date');
        $sheet->setCellValue('D1', 'Tax Base Selling Price');
        $sheet->setCellValue('E1', 'Other Tax Base Selling Price');
        $sheet->setCellValue('F1', 'VAT');
    
        // Format header
        $sheet->getStyle("A1:F1")->getFont()->setBold(true);
        $sheet->getStyle("A1:F1")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        
        $totalTaxBase = 0;
        $totalOtherTaxBase = 0;
        $totalVAT = 0;
    
        // Fill data
        $row = 2;
        foreach ($sales_data as $data) {
            // if($data->sales_order_detail_ppn_status == 2){
            //     $plainPrice = $data->sales_order_detail_large_unit_price * 1.11;
            //     // $plainPrice = $detail->sales_order_detail_large_unit_price + $ppn;
            // }
            if($ppn == 3){
                $taxBase = round($data->result);
            $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
            $lnTaxBase = round($taxBase * 11 / 12, 0);
            $lnVAT = 0;
            }else{
                $taxBase = round($data->result / 1.11, 1);
            $taxBase = ($taxBase - intval($taxBase)) > 0.5 ? ceil($taxBase) : intval($taxBase);
            $lnTaxBase = round($taxBase * 11 / 12, 0);
            $lnVAT = round($lnTaxBase * 0.12, 0);
            }
            
            $sheet->setCellValue('A' . $row, $data->customer_name);
            $sheet->setCellValue('B' . $row, '0000000000000000');
            $sheet->setCellValue('C' . $row, $data->sales_order_header_date);
            $sheet->setCellValue('D' . $row, number_format($taxBase, 2, '.', ''));
            $sheet->setCellValue('E' . $row, number_format($lnTaxBase, 2, '.', ''));
            $sheet->setCellValue('F' . $row, number_format($lnVAT, 2, '.', ''));
            $totalTaxBase += $taxBase;
        $totalOtherTaxBase += $lnTaxBase;
        $totalVAT += $lnVAT;
            $row++;
        }
        
        $sheet->setCellValue('C' . $row, 'TOTAL');
        $sheet->setCellValue('D' . $row, number_format($totalTaxBase, 2, '.', ''));
        $sheet->setCellValue('E' . $row, number_format($totalOtherTaxBase, 2, '.', ''));
        $sheet->setCellValue('F' . $row, number_format($totalVAT, 2, '.', ''));

    
        // Auto-size columns
        foreach (range('A', 'D') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }
    
        // File name
        $filename = 'RetailInvoiceDetail_' . date('Ymd_His') . '.xlsx';
    
        // Set headers for file download
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Cache-Control: max-age=0');
    
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save('php://output');

    }
    
    public function generate_xml_detail() {
        ob_end_clean(); // Pastikan buffer dibersihkan dari sebelumnya
        ob_start();     // Start clean buffer
        $ids = $this->input->post('id');
        
        $ppn      = $this->session->userdata('ppn');
        
        header("Content-Type: application/xml");
        
            $xml_data = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><TaxInvoiceBulk xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="TaxInvoice.xsd"></TaxInvoiceBulk>');
            
            $xml_data->addChild('TIN', '0825402209403000');
            $listOfTaxInvoice = $xml_data->addChild('ListOfTaxInvoice');
        foreach($ids as $row)
		{
		    
		    $header_query =  $this->Sales_orders_model->salesorder_header(array('sales_order_header_id' => $row))->row();
		    
            
            
            
            // foreach ($sales as $sale) {
                $taxInvoice = $listOfTaxInvoice->addChild('TaxInvoice');
                $taxInvoice->addChild('TaxInvoiceDate',$header_query->sales_order_header_date);
                $taxInvoice->addChild('TaxInvoiceOpt', 'Normal');
                $taxInvoice->addChild('TrxCode', '04');
                $taxInvoice->addChild('AddInfo', '');
                $taxInvoice->addChild('CustomDoc', '');
                $taxInvoice->addChild('CustomDocMonthYear',date('mY', strtotime($header_query->sales_order_header_date)));
                $taxInvoice->addChild('RefDesc', htmlspecialchars($header_query->sales_order_header_number)); 
               $taxInvoice->addChild('FacilityStamp', '');
                $taxInvoice->addChild('SellerIDTKU', '0825402209403000000000');
                // 0822984985404000000000
                
                $taxInvoice->addChild('BuyerTin', htmlspecialchars($header_query->customer_npwp));
                $taxInvoice->addChild('BuyerDocument', 'TIN');
                $taxInvoice->addChild('BuyerCountry', 'IDN');
                $taxInvoice->addChild('BuyerDocumentNumber', htmlspecialchars($header_query->customer_ktp));
                $taxInvoice->addChild('BuyerName', htmlspecialchars($header_query->customer_name));
                $taxInvoice->addChild('BuyerAdress', htmlspecialchars($header_query->customer_address));
                $taxInvoice->addChild('BuyerEmail', "");
                $taxInvoice->addChild('BuyerIDTKU',  htmlspecialchars($header_query->customer_npwp)."000000");
                $listOfGoodService = $taxInvoice->addChild('ListOfGoodService');
    		    if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
        		{
        		    $details = $this->Sales_orders_model->salesorder_detail(array('sales_order_detail_header_id' => $row,'sales_order_detail_ppn_status' => $ppn))->result();
        		}else{
        		    $details = $this->Sales_orders_model->salesorder_detail(array('sales_order_detail_header_id' => $row))->result();
        		}
                
                foreach ($details as $detail) {
                    if($detail->sales_order_detail_large_unit_quantity > 0){
                        $goodService = $listOfGoodService->addChild('GoodService');
                        if($detail->sales_order_detail_ppn_status == 2){
                            $discount = $detail->sales_order_detail_discount_total / $detail->sales_order_detail_large_unit_quantity;
                            $discountprice = $detail->sales_order_detail_large_unit_price - $discount;
                            $plainPrice = $discountprice * 1.11;
                            // $plainPrice = $detail->sales_order_detail_large_unit_price + $ppn;
                        }else{
                            $discount = $detail->sales_order_detail_discount_total / $detail->sales_order_detail_large_unit_quantity;
                            $discountprice = $detail->sales_order_detail_large_unit_price - $discount;
                            $plainPrice = $discountprice;
                        }
                        
                        if($detail->sales_order_detail_ppn_status == 3){
                            $price = round($plainPrice);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_large_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail =0;
                            
                        }else{
                            $price = round($plainPrice / 1.11, 1);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_large_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail = round($taxBaseDetail * 0.12, 0);
                        }
                        
                        
                        
                        $goodService->addChild('Opt', 'A');
                        $goodService->addChild('Code', '000000');
                        $goodService->addChild('Name', htmlspecialchars($detail->sales_order_detail_item_name));
                        $goodService->addChild('Unit', 'UM.0022');
                        $goodService->addChild('Price', number_format($price, 2, '.', ''));
                        $goodService->addChild('Qty', $qty);
                        $goodService->addChild('TotalDiscount', number_format($discount, 2, '.', ''));
                        $goodService->addChild('TaxBase', number_format($total, 2, '.', ''));
                        $goodService->addChild('OtherTaxBase', number_format($taxBaseDetail, 2, '.', ''));
                        $goodService->addChild('VATRate', '12');
                        $goodService->addChild('VAT', number_format($vatDetail, 2, '.', ''));
                        $goodService->addChild('STLGRate', '0');
                        $goodService->addChild('STLG', '0');
                    }
                    
                    if($detail->sales_order_detail_medium_unit_quantity > 0){
                        $goodService = $listOfGoodService->addChild('GoodService');
                        if($detail->sales_order_detail_ppn_status == 2){
                            $plainPrice = $detail->sales_order_detail_medium_unit_price * 1.11;
                            // $plainPrice = $detail->sales_order_detail_medium_unit_price + $ppn;
                        }else{
                            $plainPrice = $detail->sales_order_detail_medium_unit_price;
                        }
                        
                        if($detail->sales_order_detail_ppn_status == 3){
                            $price = round($plainPrice);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_medium_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail =0;
                            
                        }else{
                            $price = round($plainPrice / 1.11, 1);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_medium_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail = round($taxBaseDetail * 0.12, 0);
                        }
                        // $price = round($plainPrice / 1.11, 1);
                        // $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                        // $qty = $detail->sales_order_detail_medium_unit_quantity;
                        // $discount = 0;
                        // $total = ($price * $qty) - $discount;
                        // $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                        // $taxBaseDetail = round($total * 11 / 12, 0);
                        // $vatDetail = round($taxBaseDetail * 0.12, 0);
                        
                        $goodService->addChild('Opt', 'A');
                        $goodService->addChild('Code', '000000');
                        $goodService->addChild('Name', htmlspecialchars($detail->sales_order_detail_item_name));
                        $goodService->addChild('Unit', 'UM.0022');
                        $goodService->addChild('Price', number_format($price, 2, '.', ''));
                        $goodService->addChild('Qty', $qty);
                        $goodService->addChild('TotalDiscount', number_format($discount, 2, '.', ''));
                        $goodService->addChild('TaxBase', number_format($total, 2, '.', ''));
                        $goodService->addChild('OtherTaxBase', number_format($taxBaseDetail, 2, '.', ''));
                        $goodService->addChild('VATRate', '12');
                        $goodService->addChild('VAT', number_format($vatDetail, 2, '.', ''));
                        $goodService->addChild('STLGRate', '0');
                        $goodService->addChild('STLG', '0');
                    }
                    
                    if($detail->sales_order_detail_small_unit_quantity > 0){
                        $goodService = $listOfGoodService->addChild('GoodService');
                        if($detail->sales_order_detail_ppn_status == 2){
                            $plainPrice = $detail->sales_order_detail_small_unit_price * 1.11;
                            // $plainPrice = $detail->sales_order_detail_small_unit_price + $ppn;
                        }else{
                            $plainPrice = $detail->sales_order_detail_small_unit_price;
                        }
                        
                        if($detail->sales_order_detail_ppn_status == 3){
                            $price = round($plainPrice);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_small_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail =0;
                            
                        }else{
                            $price = round($plainPrice / 1.11, 1);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_small_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail = round($taxBaseDetail * 0.12, 0);
                        }
                        // $price = round($plainPrice / 1.11, 1);
                        // $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                        // $qty = $detail->sales_order_detail_small_unit_quantity;
                        // $discount = 0;
                        // $total = ($price * $qty) - $discount;
                        // $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                        // $taxBaseDetail = round($total * 11 / 12, 0);
                        // $vatDetail = round($taxBaseDetail * 0.12, 0);
                        
                        $goodService->addChild('Opt', 'A');
                        $goodService->addChild('Code', '000000');
                        $goodService->addChild('Name', htmlspecialchars($detail->sales_order_detail_item_name));
                        $goodService->addChild('Unit', 'UM.0022');
                        $goodService->addChild('Price', number_format($price, 2, '.', ''));
                        $goodService->addChild('Qty', $qty);
                        $goodService->addChild('TotalDiscount', number_format($discount, 2, '.', ''));
                        $goodService->addChild('TaxBase', number_format($total, 2, '.', ''));
                        $goodService->addChild('OtherTaxBase', number_format($taxBaseDetail, 2, '.', ''));
                        $goodService->addChild('VATRate', '12');
                        $goodService->addChild('VAT', number_format($vatDetail, 2, '.', ''));
                        $goodService->addChild('STLGRate', '0');
                        $goodService->addChild('STLG', '0');
                    }
                    
                }
            // }
            
            // Generate XML file
        $xml_content = $xml_data->asXML();
        $filename = 'RetailInvoice_' . date('Ymd_His') . '.xml';
        ob_clean();
        // Set headers for file download
        header('Content-Type: application/xml');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Content-Length: ' . strlen($xml_content));
        header('Pragma: no-cache');
        header('Expires: 0');
    
        echo $xml_content;
        
		}
        // exit;
    }
    
    public function generate_xml_detail_nik() {
         ob_end_clean(); // Pastikan buffer dibersihkan dari sebelumnya
        ob_start();     // Start clean buffer
        $ids = $this->input->post('id');
        
        $ppn      = $this->session->userdata('ppn');
        
        header("Content-Type: application/xml");
        
            $xml_data = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><TaxInvoiceBulk xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="TaxInvoice.xsd"></TaxInvoiceBulk>');
            
            $xml_data->addChild('TIN', '0825402209403000');
            $listOfTaxInvoice = $xml_data->addChild('ListOfTaxInvoice');
        foreach($ids as $row)
		{
		    
		    $header_query =  $this->Sales_orders_model->salesorder_header(array('sales_order_header_id' => $row))->row();
		    
            
            
            
            // foreach ($sales as $sale) {
                $taxInvoice = $listOfTaxInvoice->addChild('TaxInvoice');
                $taxInvoice->addChild('TaxInvoiceDate',$header_query->sales_order_header_date);
                $taxInvoice->addChild('TaxInvoiceOpt', 'Normal');
                $taxInvoice->addChild('TrxCode', '04');
                $taxInvoice->addChild('AddInfo', '');
                $taxInvoice->addChild('CustomDoc', '');
//                 $taxInvoice->addChild('CustomDocMonthYear',
// date('mY', strtotime($header_query->sales_order_header_date))
//                 );
                $taxInvoice->addChild('RefDesc', htmlspecialchars($header_query->sales_order_header_number)); 
               $taxInvoice->addChild('FacilityStamp', '');
                $taxInvoice->addChild('SellerIDTKU', '0825402209403000000000');
                // 0822984985404000000000
                
                $taxInvoice->addChild('BuyerTin', "0000000000000000");
                $taxInvoice->addChild('BuyerDocument', 'National ID');
                $taxInvoice->addChild('BuyerCountry', 'IDN');
                $taxInvoice->addChild('BuyerDocumentNumber', htmlspecialchars($header_query->customer_ktp));
                $taxInvoice->addChild('BuyerName', htmlspecialchars($header_query->customer_name));
                $taxInvoice->addChild('BuyerAdress', htmlspecialchars($header_query->customer_address));
                $taxInvoice->addChild('BuyerEmail', "");
                $taxInvoice->addChild('BuyerIDTKU',  "0000000000000000000000");
                $listOfGoodService = $taxInvoice->addChild('ListOfGoodService');
    		    if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
        		{
        		    $details = $this->Sales_orders_model->salesorder_detail(array('sales_order_detail_header_id' => $row,'sales_order_detail_ppn_status' => $ppn))->result();
        		}else{
        		    $details = $this->Sales_orders_model->salesorder_detail(array('sales_order_detail_header_id' => $row))->result();
        		}
                
                foreach ($details as $detail) {
                    if($detail->sales_order_detail_large_unit_quantity > 0){
                        $goodService = $listOfGoodService->addChild('GoodService');
                        if($detail->sales_order_detail_ppn_status == 2){
                            $discount = $detail->sales_order_detail_discount_total / $detail->sales_order_detail_large_unit_quantity;
                            $discountprice = $detail->sales_order_detail_large_unit_price - $discount;
                            $plainPrice = $discountprice * 1.11;
                            // $plainPrice = $detail->sales_order_detail_large_unit_price + $ppn;
                        }else{
                            $discount = $detail->sales_order_detail_discount_total / $detail->sales_order_detail_large_unit_quantity;
                            $discountprice = $detail->sales_order_detail_large_unit_price - $discount;
                            $plainPrice = $discountprice;
                        }
                        
                        if($detail->sales_order_detail_ppn_status == 3){
                            $price = round($plainPrice);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_large_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail =0;
                            
                        }else{
                            $price = round($plainPrice / 1.11, 1);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_large_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail = round($taxBaseDetail * 0.12, 0);
                        }
                        
                        
                        
                        $goodService->addChild('Opt', 'A');
                        $goodService->addChild('Code', '000000');
                        $goodService->addChild('Name', htmlspecialchars($detail->sales_order_detail_item_name));
                        $goodService->addChild('Unit', 'UM.0022');
                        $goodService->addChild('Price', number_format($price, 2, '.', ''));
                        $goodService->addChild('Qty', $qty);
                        $goodService->addChild('TotalDiscount', number_format($discount, 2, '.', ''));
                        $goodService->addChild('TaxBase', number_format($total, 2, '.', ''));
                        $goodService->addChild('OtherTaxBase', number_format($taxBaseDetail, 2, '.', ''));
                        $goodService->addChild('VATRate', '12');
                        $goodService->addChild('VAT', number_format($vatDetail, 2, '.', ''));
                        $goodService->addChild('STLGRate', '0');
                        $goodService->addChild('STLG', '0');
                    }
                    
                    if($detail->sales_order_detail_medium_unit_quantity > 0){
                        $goodService = $listOfGoodService->addChild('GoodService');
                        if($detail->sales_order_detail_ppn_status == 2){
                            $plainPrice = $detail->sales_order_detail_medium_unit_price * 1.11;
                            // $plainPrice = $detail->sales_order_detail_medium_unit_price + $ppn;
                        }else{
                            $plainPrice = $detail->sales_order_detail_medium_unit_price;
                        }
                        
                        if($detail->sales_order_detail_ppn_status == 3){
                            $price = round($plainPrice);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_medium_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail =0;
                            
                        }else{
                            $price = round($plainPrice / 1.11, 1);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_medium_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail = round($taxBaseDetail * 0.12, 0);
                        }
                        // $price = round($plainPrice / 1.11, 1);
                        // $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                        // $qty = $detail->sales_order_detail_medium_unit_quantity;
                        // $discount = 0;
                        // $total = ($price * $qty) - $discount;
                        // $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                        // $taxBaseDetail = round($total * 11 / 12, 0);
                        // $vatDetail = round($taxBaseDetail * 0.12, 0);
                        
                        $goodService->addChild('Opt', 'A');
                        $goodService->addChild('Code', '000000');
                        $goodService->addChild('Name', htmlspecialchars($detail->sales_order_detail_item_name));
                        $goodService->addChild('Unit', 'UM.0022');
                        $goodService->addChild('Price', number_format($price, 2, '.', ''));
                        $goodService->addChild('Qty', $qty);
                        $goodService->addChild('TotalDiscount', number_format($discount, 2, '.', ''));
                        $goodService->addChild('TaxBase', number_format($total, 2, '.', ''));
                        $goodService->addChild('OtherTaxBase', number_format($taxBaseDetail, 2, '.', ''));
                        $goodService->addChild('VATRate', '12');
                        $goodService->addChild('VAT', number_format($vatDetail, 2, '.', ''));
                        $goodService->addChild('STLGRate', '0');
                        $goodService->addChild('STLG', '0');
                    }
                    
                    if($detail->sales_order_detail_small_unit_quantity > 0){
                        $goodService = $listOfGoodService->addChild('GoodService');
                        if($detail->sales_order_detail_ppn_status == 2){
                            $plainPrice = $detail->sales_order_detail_small_unit_price * 1.11;
                            // $plainPrice = $detail->sales_order_detail_small_unit_price + $ppn;
                        }else{
                            $plainPrice = $detail->sales_order_detail_small_unit_price;
                        }
                        
                        if($detail->sales_order_detail_ppn_status == 3){
                            $price = round($plainPrice);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_small_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail =0;
                            
                        }else{
                            $price = round($plainPrice / 1.11, 1);
                            $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                            $qty = $detail->sales_order_detail_small_unit_quantity;
                            $discount = 0;
                            $total = ($price * $qty) - $discount;
                            $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                            $taxBaseDetail = round($total * 11 / 12, 0);
                            $vatDetail = round($taxBaseDetail * 0.12, 0);
                        }
                        // $price = round($plainPrice / 1.11, 1);
                        // $price = ($price - intval($price)) > 0.5 ? ceil($price) : intval($price);
                        // $qty = $detail->sales_order_detail_small_unit_quantity;
                        // $discount = 0;
                        // $total = ($price * $qty) - $discount;
                        // $total = ($total - intval($total)) > 0.5 ? ceil($total) : intval($total);
                        // $taxBaseDetail = round($total * 11 / 12, 0);
                        // $vatDetail = round($taxBaseDetail * 0.12, 0);
                        
                        $goodService->addChild('Opt', 'A');
                        $goodService->addChild('Code', '000000');
                        $goodService->addChild('Name', htmlspecialchars($detail->sales_order_detail_item_name));
                        $goodService->addChild('Unit', 'UM.0022');
                        $goodService->addChild('Price', number_format($price, 2, '.', ''));
                        $goodService->addChild('Qty', $qty);
                        $goodService->addChild('TotalDiscount', number_format($discount, 2, '.', ''));
                        $goodService->addChild('TaxBase', number_format($total, 2, '.', ''));
                        $goodService->addChild('OtherTaxBase', number_format($taxBaseDetail, 2, '.', ''));
                        $goodService->addChild('VATRate', '12');
                        $goodService->addChild('VAT', number_format($vatDetail, 2, '.', ''));
                        $goodService->addChild('STLGRate', '0');
                        $goodService->addChild('STLG', '0');
                    }
                    
                }
            // }
            
            // Generate XML file
        $xml_content = $xml_data->asXML();
        $filename = 'RetailInvoice_' . date('Ymd_His') . '.xml';
         ob_clean(); // Pastikan buffer dibersihkan dari sebelumnya
        // ob_start();     // Start clean buffer
        // Set headers for file download
        header('Content-Type: application/xml');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        header('Content-Length: ' . strlen($xml_content));
        header('Pragma: no-cache');
        header('Expires: 0');
    
        echo $xml_content;
		}
        
    }

}

?>
