<?php

/**
 * Accounts Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Accounts_model extends Model
{

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_accounts a');
// 		$sql->join('master_account_types b', 'b.account_type_id = a.account_type_id', 'inner');
		$sql->join('master_account_headers c', 'c.account_header_id = a.account_header_id', 'inner');
		$sql->join('master_account_header_childs d', 'd.account_header_child_id = a.account_header_child_id', 'inner');
		$sql->join('master_account_groups e', 'e.account_group_id = c.account_group_id', 'inner');

		$sql->order_by('account_number');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_settings($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('account_settings');

		$sql->order_by('id');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_settings_advance($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('account_settings a');
		$sql->join('master_accounts b', 'b.account_id = a.account_id', 'inner');
		$sql->join('master_account_headers c', 'c.account_header_id = b.account_header_id', 'inner');
		$sql->join('master_account_header_childs d', 'd.account_header_child_id = b.account_header_child_id', 'inner');
		$sql->join('master_account_groups e', 'e.account_group_id = c.account_group_id', 'inner');

		$sql->order_by('id');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_search($search = '',$where='')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_accounts a');
// 		$sql->join('master_account_types b', 'b.account_type_id = a.account_type_id', 'inner');
		$sql->join('master_account_headers c', 'c.account_header_id = a.account_header_id', 'inner');
		$sql->join('master_account_header_childs d', 'd.account_header_child_id = a.account_header_child_id', 'inner');
		$sql->join('master_account_groups e', 'e.account_group_id = c.account_group_id', 'inner');

		$sql->order_by('account_name');

		if ($search != "") {
			$sql->like('account_number', $search);
			$sql->or_like('account_name', $search);
// 			$sql->or_like('type_name', $search);
		}
		
		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data)
	{
		return $this->db->insert('master_accounts', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('account_id', $id);
		return $this->db->update('master_accounts', $data);
	}

	public function delete($id)
	{
		$this->db->where('account_id', $id);
		return $this->db->delete('master_accounts');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('master_accounts');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
