<?php

/**
 * Items Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Items_model extends Model
{

	public function get_conf($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('conf_items');
		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function update_conf($id, $data)
	{
		$this->db->where('id', $id);
		return $this->db->update('conf_items', $data);
	}

	public function get_data($where = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'left');
		$sql->join('master_group_childs c', 'c.group_child_id = a.item_group_child_id', 'left');
		$sql->order_by('item_name');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}
	public function get_data_ubah($where = '',$start='')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'left');
		$sql->join('master_group_childs c', 'c.group_child_id = a.item_group_child_id', 'left');
		$sql->order_by('item_name');

		if ($where != "") {
			$sql->where($where);
		}
        if($start != "" ){
		    $this->db->like('item_name', $start, 'after');
		  //  $this->db->where('selling_order_detail_item_name LIKE', '%' . $start . '%');
		}
		$get = $sql->get();

		return $get;
	}
	

	public function get_data_unit($where = '')
	{
		$sql = $this->db;

		$sql->select('a.unit_name as unit_n, COUNT(unit_id) AS jml');
		$sql->from('master_units a');
		$sql->join('master_items b', 'b.large_unit = a.unit_name', 'inner');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_search($search = '', $group = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'left');
		$sql->join('master_group_childs c', 'c.group_child_id = a.item_group_child_id', 'left');
		$sql->order_by('item_name');

		if ($search != '') {
            // Split search input into words
            $keywords = explode(' ', trim($search));
    
            // Group the conditions to enforce AND logic across all words
            $sql->group_start();
            foreach ($keywords as $word) {
                $sql->like('item_name', $word);
            }
            $sql->group_end();
        }

		if ($group != '') {
			$sql->where('item_group_id', $group);
		}

		$sql->where('mobile_active', '1');
		$sql->limit('30');

		$get = $sql->get();

		return $get;
	}
	

	public function get_data_search_mobile($search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'left');
		$sql->join('master_group_childs c', 'c.group_child_id = a.item_group_child_id', 'left');
		$sql->order_by('item_name');

		if ($search != '') {
			$sql->like('item_name', $search);
		}

		$sql->where('mobile_active', '1');

		$get = $sql->get();

		return $get;
	}
		public function updateStock()
	{
// 		$sql = $this->db;

	 // Prepare the SQL query to call the stored procedure
        $sql = "CALL UpdateStock()";

        // Execute the query
        $query = $this->db->query($sql);

		return $query;
	}
	
	public function updateStockGd1()
	{
// 		$sql = $this->db;

	 // Prepare the SQL query to call the stored procedure
        $sql = "CALL UpdateStockGd1()";

        // Execute the query
        $query = $this->db->query($sql);

		return $query;
	}
	
	public function updateStockGd2()
	{
// 		$sql = $this->db;

	 // Prepare the SQL query to call the stored procedure
        $sql = "CALL UpdateStockGd2()";

        // Execute the query
        $query = $this->db->query($sql);

		return $query;
	}
	
	public function updateStockGd3()
	{
// 		$sql = $this->db;

	 // Prepare the SQL query to call the stored procedure
        $sql = "CALL UpdateStockGd3()";

        // Execute the query
        $query = $this->db->query($sql);

		return $query;
	}

	public function save($data)
	{
		return $this->db->insert('master_items', $data);
	}

	public function save_grouping_quantity($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('master_items_grouping_quantity', $data);
		}

		return $this->db->insert('master_items_grouping_quantity', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('item_id', $id);
		return $this->db->update('master_items', $data);
	}

	public function update_operational($data)
	{
		// $this->db->where('item_id', $id);
		return $this->db->update('master_items', $data);
	}

	public function delete($id)
	{
		$this->db->where('item_id', $id);
		return $this->db->delete('master_items');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('master_items');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
