<?php
/**
 * Group Prices Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Group_prices_model extends Model {

	public function get_data_group_customer($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_group_customers');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_group_price($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_group_prices a');
	    $sql->join('master_items b', 'b.item_id = a.item_id', 'inner');
	    $sql->join('master_group_customers c', 'c.group_customer_id = a.group_customer_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_limit($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_group_prices a');
	    $sql->join('master_items b', 'b.item_id = a.item_id', 'inner');

		if ($where != '') {
			$sql->where($where);
		}

		$sql->limit(1);

		$get = $sql->get();

		return $get;
	}

	public function get_data_range($item_id='', $quantity_large='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('master_group_prices a');
	    // $sql->join('master_items b', 'b.item_id = a.item_id', 'inner');

		$sql->where("item_id", $item_id);
		$sql->where("'$quantity_large' BETWEEN minimum_order and maximum_order");

		$get = $sql->get();

		return $get;
	}

	public function save($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('master_group_prices', $data);
		}

		return $this->db->insert('master_group_prices', $data);
	}

	public function delete($id)
	{
		$this->db->where("item_id", $id);
		return $this->db->delete("master_group_prices");
	}


}

?>
