<?php
/**
 * Batches Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Batches_model extends Model {
	
	public function meeting_schedules($batch_id='', $program_id='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('meeting_schedules');
		
    	if ($batch_id != '') {
			$sql->where('batch_id', $batch_id);
		}

		if ($program_id != '') {
			$sql->where('program_id', $program_id);
		}

		$get = $sql->get();

		return $get;
	}

	public function batch_header($id='', $order='')
	{
		$sql = $this->db;

		$sql->select('
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				meeting_schedules m
				WHERE m.batch_id = a.batch_header_id
				AND m.program_id = b.program_header_id
			)
			AS all_date,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				meeting_schedules m
				WHERE m.batch_id = a.batch_header_id
				AND m.program_id = b.program_header_id
				AND meeting_date > CURDATE()
			)
			AS running,
			a.*, b.*, c.*, d.*, e.*, CONVERT(substr(a.batch_header_name, "1", "2"),UNSIGNED INTEGER) as batch_number, CONVERT(substr(a.batch_header_name, "5", "5"),UNSIGNED INTEGER) as batch_year,
			(
				SELECT COUNT(*)
				FROM
				meeting_schedules m
				WHERE m.batch_id = a.batch_header_id
				AND m.program_id = b.program_header_id
				AND meeting_date < CURDATE()
			)
			AS done
		');

		$sql->from('batch_headers a');
		$sql->join('program_headers b', 'b.program_header_id = a.batch_header_program_id', 'inner');
		$sql->join('master_program_types c', 'c.program_type_id = b.program_header_type_id', 'inner');
		$sql->join('master_program_classes d', 'd.program_class_id = b.program_header_class_id', 'inner');
		$sql->join('master_program_accreditations e', 'e.program_accreditation_id = b.program_header_accreditation_id', 'left');
		// $sql->join('meeting_schedules d', 'd.batch_id = a.batch_header_id and d.program_id = b.program_header_id', 'inner');
		
		if ($id != '') {
			$sql->where('batch_header_id', $id);
		}
		
		if ($order != '') {
 			$sql->order_by($order);
		}
		$sql->order_by('batch_year desc, batch_number desc');

		$get = $sql->get();

		return $get;
	}

	public function batch_detail($id="")
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('batch_details a');
	    $sql->join('master_trainees b', 'b.trainee_id = a.batch_detail_trainee_id', 'inner');
	    $sql->join('master_companies c', 'c.company_id = b.trainee_company_id', 'inner');
	    // $sql->join('master_job_titles d', 'd.job_title_id = b.trainee_job_title_id', 'inner');

		if ($id != "") {
			$sql->where("batch_detail_header_id", $id);
		}

		$sql->group_by(array('batch_detail_trainee_id', 'batch_detail_header_id'));

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('batch_headers', $data);
		}

		return $this->db->insert('batch_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('batch_details', $data);
		}

		return $this->db->insert('batch_details', $data);
	}

	public function save_graduate($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('graduates', $data);
		}

		return $this->db->insert('graduates', $data);
	}

	public function save_meeting_schedules($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('meeting_schedules', $data);
		}

		return $this->db->insert('meeting_schedules', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('batch_header_id', $id);
		return $this->db->update('batch_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("batch_header_id", $id);
		return $this->db->delete("batch_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("batch_detail_header_id", $id);
		return $this->db->delete("batch_details");
	}

	public function delete_graduate($id)
	{
		$this->db->where("batch_id", $id);
		return $this->db->delete("graduates");
	}

	public function delete_graduate_advance($where)
	{
		$this->db->where($where);
		return $this->db->delete("graduates");
	}

	public function delete_schedule($where)
	{
		$this->db->where($where);
		return $this->db->delete("meeting_schedules");
	}

}

?>
