<?php
/**
 * Credits Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Credits_model extends Model {

	public function credit_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(credit_headers.credit_header_number, 4) as serial_number', FALSE);
		$sql->where('MONTH(credit_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('credit_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('credit_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function credit_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('credit_headers a');
	    $sql->join('master_customers b', 'b.customer_id = a.credit_header_customer_id', 'inner');
	    $sql->join('master_banks c', 'c.bank_id = a.credit_header_bank_id', 'left');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function credit_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('credit_details a');
	    $sql->join('sales_order_headers b', 'b.sales_order_header_id = a.credit_detail_sales_order_header_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('credit_headers', $data);
		}

		return $this->db->insert('credit_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('credit_details', $data);
		}

		return $this->db->insert('credit_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('credit_header_id', $id);
		return $this->db->update('credit_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("credit_header_id", $id);
		return $this->db->delete("credit_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("credit_detail_header_id", $id);
		return $this->db->delete("credit_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("credit_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("credit_details");
	}

}

?>
