<?php

/**
 * Items Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use core\Model;

class Order_model extends Model
{

	public function autonumber()
	{
		$sql = $this->db;

		$sql->select('RIGHT(orders.number, 3) as serial_number', FALSE);
		$sql->where('MONTH(date) = MONTH(CURRENT_DATE())');
		$sql->order_by('number', 'DESC');
		$sql->limit(1);
		$query = $sql->get('orders');
		if ($query->num_rows() <> 0) {
			$data = $query->row();
			$serial_number = intval($data->serial_number) + 1;
		} else {
			$serial_number = 001;
		}

		$serial_number_generate = str_pad($serial_number, 3, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function get_items($where = '', $search = '')
	{
		$sql = $this->db;

		$sql->select('a.*, b.name as group_name');
		$sql->from('items a');
		$sql->join('groups b', 'b.id_group = a.id_group', 'inner');

		$sql->order_by('name');

		if ($where != "") {
			$sql->where($where);
		}

		if ($search != '') {
			$sql->like('name', $search);
			$sql->or_like('description', $search);
			$sql->or_like('group', $search);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_items_group()
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('groups');
		$sql->order_by('name');

		// if ($where != "") {
		// 	$sql->where($where);
		// }

		$get = $sql->get();

		return $get;
	}

	public function get_tables($where = "")
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('tables');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function get_orders($where = "")
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('orders');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}
	
	public function get_orders_detail($where = "")
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('orders_detail');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_unit($where = '')
	{
		$sql = $this->db;

		$sql->select('a.unit_name as unit_n, COUNT(unit_id) AS jml');
		$sql->from('master_units a');
		$sql->join('master_items b', 'b.large_unit = a.unit_name', 'inner');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_search($search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'left');
		$sql->join('master_group_childs c', 'c.group_child_id = a.item_group_child_id', 'left');
		$sql->order_by('item_name');

		if ($search != '') {
			$sql->like('item_name', $search);
			$sql->or_like('group_name', $search);
			$sql->or_like('group_child_name', $search);
		}

		$get = $sql->get();

		return $get;
	}

	public function get_data_search_mobile($search = '')
	{
		$sql = $this->db;

		$sql->select('*');
		$sql->from('master_items a');
		$sql->join('master_groups b', 'b.group_id = a.item_group_id', 'left');
		$sql->join('master_group_childs c', 'c.group_child_id = a.item_group_child_id', 'left');
		$sql->order_by('item_name');

		if ($search != '') {
			$sql->like('item_name', $search);
		}

		$sql->where('mobile_active', '1');

		$get = $sql->get();

		return $get;
	}


	public function save_header($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('orders', $data);
		}

		return $this->db->insert('orders', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if ($batch) {
			return $this->db->insert_batch('orders_detail', $data);
		}

		return $this->db->insert('orders_detail', $data);
	}

	public function update($id, $data)
	{
		$this->db->where('item_id', $id);
		return $this->db->update('master_items', $data);
	}

	public function delete($id)
	{
		$this->db->where('item_id', $id);
		return $this->db->delete('master_items');
	}

	public function check_id($where)
	{
		$this->db->select("*");
		$this->db->from('master_items');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}
}
