<?php
/**
 * Point Redeems Model
 * Modif Core Model with Namespace
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Ptsredeems_model extends Model {

	public function redeem_autonumber()
	{	
		$sql = $this->db;

		$sql->select('RIGHT(ptsredeems.ptsredeem_number, 4) as serial_number', FALSE);
		// $sql->where('MONTH(sales_order_header_date) = MONTH(CURRENT_DATE())');
		$sql->order_by('ptsredeem_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('ptsredeems');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 0001;    
		}

		$serial_number_generate = str_pad($serial_number, 4, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function get_data($where='') {
		$sql = $this->db;

		$sql->select('*');
        $sql->from('ptsredeems a');
        $sql->join('master_customers b', 'b.customer_id = a.ptsredeem_customer_id', 'inner');
		$sql->order_by('ptsredeem_date', 'desc');

		if ($where != "") {
			$sql->where($where);
		}

		$get = $sql->get();

		return $get;
	}

	public function save($data) {
		return $this->db->insert('ptsredeems', $data);
	}

	public function update($id, $data) {
		$this->db->where('ptsredeem_id', $id);
		return $this->db->update('ptsredeems', $data);
	}

	public function delete($id) {
		$this->db->where('ptsredeem_id', $id);
		return $this->db->delete('ptsredeems');
	}

	public function check_id($where) {
		$this->db->select("*");
		$this->db->from('ptsredeems');
		$this->db->where($where);
		$query = $this->db->get();
		return $query->result();
	}

}

?>
