<?php
/**
 * Purchase Orders Model
 *
 * Modif Core Model with Namespace
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use core\Model;

class Purchase_orders_model extends Model {

	public function purchaseorder_autonumber($supp_code)
	{	
		$sql = $this->db;

		$sql->select('RIGHT(purchase_order_headers.purchase_order_header_number, 2) as serial_number', FALSE);
		$sql->where('MONTH(purchase_order_header_date) = MONTH(CURRENT_DATE())');
		$sql->where('SUBSTR(purchase_order_headers.purchase_order_header_number, 1, 2) = "'.$supp_code.'"');
		$sql->order_by('purchase_order_header_number', 'DESC');
		$sql->limit(1);    
		$query = $sql->get('purchase_order_headers');  
		if($query->num_rows() <> 0){         
			$data = $query->row();      
			$serial_number = intval($data->serial_number) + 1;    
		}
		else {          
			$serial_number = 01;    
		}

		$serial_number_generate = str_pad($serial_number, 2, "0", STR_PAD_LEFT);
		$result = $serial_number_generate;
		return $result;
	}

	public function purchaseorder_header($where='', $order='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail($where='', $order='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_order_details a');
	    $sql->join('master_items b', 'b.item_id = a.purchase_order_detail_item_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_advance($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*');
	    $sql->from('purchase_order_details a');
	    $sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.purchase_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_order_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.purchase_order_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_detail_sum($where='', $order='', $group_by='', $where_hed='')
	{
		$sql = $this->db;

		$sql->select('*, sum(purchase_order_detail_result_large + purchase_order_detail_result_medium + purchase_order_detail_result_small) as result');
	    $sql->from('purchase_order_details a');
	    $sql->join('purchase_order_headers b', 'b.purchase_order_header_id = a.purchase_order_detail_header_id', 'left');
	    $sql->join('master_items c', 'c.item_id = a.purchase_order_detail_item_id', 'left');
	    $sql->join('master_suppliers d', 'd.supplier_id = b.purchase_order_header_supplier_id', 'left');

		if ($where != '') {
			$sql->where($where);
		}

		if ($where_hed != '') {
			$sql->where($where_hed);
		}

		if ($group_by != '') {
			$sql->group_by($group_by);
		}

		if ($order != '') {
			$sql->order_by($order);
		}

		$get = $sql->get();

		return $get;
	}

	public function purchaseorder_headersearch($type='', $supplier='', $search='')
	{
    	$sql = $this->db;

		$sql->select('*');
		$sql->from('purchase_order_headers a');
	    $sql->join('master_suppliers b', 'b.supplier_id = a.purchase_order_header_supplier_id', 'inner');

    	if ($search != '')
		{
			$sql->like('purchase_order_header_number', $search);
			$sql->or_like('purchase_order_header_date', $search);
		}

		$sql->where('purchase_order_header_supplier_id', $supplier);
		$sql->where('status_paid', 0);
		$sql->order_by('purchase_order_header_number ASC');

		$get = $sql->get();

		return $get;
	}

	public function save_header($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('purchase_order_headers', $data);
		}

		return $this->db->insert('purchase_order_headers', $data);
	}

	public function save_detail($data, $batch = false)
	{
		if($batch)
		{
			return $this->db->insert_batch('purchase_order_details', $data);
		}

		return $this->db->insert('purchase_order_details', $data);
	}

	public function update_header($id, $data) {
		$this->db->where('purchase_order_header_id', $id);
		return $this->db->update('purchase_order_headers', $data);
	}

	public function delete_header($id)
	{
		$this->db->where("purchase_order_header_id", $id);
		return $this->db->delete("purchase_order_headers");
	}

	public function delete_detail($id)
	{
		$this->db->where("purchase_order_detail_header_id", $id);
		return $this->db->delete("purchase_order_details");
	}

	public function truncate_header()
	{
		return $this->db->empty_table("purchase_order_headers");
	}

	public function truncate_detail()
	{
		return $this->db->empty_table("purchase_order_details");
	}

}

?>
