/**
 * Javascript Embed
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

window.INDEX = (function ($) {
	return {

		initVue: null,
		elVue: '#vue-master',
		elForm: ".edit-form",

		elTable: "#embed-table",
		elClose: '.embed-close',
		elModal: ".edit-modal",
		elModalC: ".edit-modal-content",

		// checkbox
		elParentCheckbox: ".check-all",
		elSubCheckbox: ".check-sub",

		urlGetData: window.APP.siteUrl + 'adm/order/get_items',
		urlList: window.APP.siteUrl + 'adm/order/get_details',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// vue
		handleVue: function () {
			var that = this;

			that.initVue = new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					orderData: [],
					listData: [],
					groupData: [],
					typeOrderValue: 'Dine In',
					typeOrderValueBhs: 'Makan di Tempat',
					a:'',
					groupSelected:0,
					quantity: 0,
					editStatus: 0,
					onBehalf:''
				},
				methods: {

					showDetail: function (row, idx) {
						// show modal
						var vue = this;
						

						$(that.elModal).modal("show");

						
						var quantity = 0;
						var notes = "";
						var button_text = "Tambah Pesanan";
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = vue.orderData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							
							quantity = vue.orderData[index].quantity;
							notes = vue.orderData[index].notes;
							button_text = "Perbaharui Pesanan";
						}

						$.ajax({
							url: that.urlList,
							type: 'post',
							// dataType: "json",
							data: {
								row         : row,
								idx         : idx,
								quantity       : quantity,
								notes       : notes,
								group       : vue.listData[idx].group,
								id          : vue.listData[idx].id,
								code        : vue.listData[idx].code,
								name        : vue.listData[idx].name,
								description : vue.listData[idx].description,
								group       : vue.listData[idx].group_name,
								price       : vue.listData[idx].price,
								img_filename: vue.listData[idx].img_filename,
								quantity    : vue.listData[idx].quantity,
							},
							success: function (response) {
								$(that.elModalC).html(response);
								var editInit = window.EMBED;
								var editVueInit = editInit.initVue;

								editVueInit.data_idx = idx;
								editVueInit.data_row = row;
								editVueInit.quantity = quantity;
								editVueInit.notes = notes;
								editVueInit.button_text = button_text;
							}
						});

					},

					typeOrder: function (btnValue, btnValueBhs) {
						// show modal
						var vue = this;
					
						vue.typeOrderValue = btnValue;
						vue.typeOrderValueBhs = btnValueBhs;
					},

					deleteDetail: function (row, idx) {
						// show modal
						var vue = this;
						
						Swal.fire({
							title: "Perhatian",
							text: "Anda yakin ingin menghapus "+ vue.orderData[idx].name + " dari pesanan?",
							type: 'warning',
							showCancelButton: true,
							confirmButtonColor: '#3085d6',
							cancelButtonColor: '#d33',
							confirmButtonText: 'Ya, Hapus!',
							cancelButtonText: 'Batal'
						}).then((result) => {
							if (result.value) {
								myArray = vue.a;
								var myIndex = myArray.indexOf(row.id);
								if (myIndex !== -1) {
									myArray.splice(myIndex, 1);
								}
								vue.orderData.splice(idx, 1);
							}
						})

						
						vue.checkData_isExists();

					},

					editOrder: function () {
						// show modal
						var vue = this;
						
						var status = (vue.editStatus == 0 ? 1 : 0);
						vue.editStatus = status;
					},

					handleQty: function (row, idx, func) {
						var vue= this;

						(func == '+' ? row.quantity++ : row.quantity--);
						if(row.quantity == 0){
							Swal.fire({
								title: "Perhatian",
								text: "Anda yakin ingin menghapus "+ vue.orderData[idx].name + " dari pesanan?",
								type: 'warning',
								showCancelButton: true,
								confirmButtonColor: '#3085d6',
								cancelButtonColor: '#d33',
								confirmButtonText: 'Ya, Hapus!',
								cancelButtonText: 'Batal'
							}).then((result) => {
								if (result.value) {
									myArray = vue.a;
									var myIndex = myArray.indexOf(row.id);
									if (myIndex !== -1) {
										myArray.splice(myIndex, 1);
									}
									vue.orderData.splice(idx, 1);
								}else{
									row.quantity++;
									vue.$set(vue.orderData[idx], 'total', (vue.orderData[idx].quantity * vue.orderData[idx].price.replace(/,/g, '')).toLocaleString("en-US"));
								}
							})
	
							
							vue.checkData_isExists();
						}
						
						vue.$set(vue.orderData[idx], 'total', (vue.orderData[idx].quantity * vue.orderData[idx].price.replace(/,/g, '')).toLocaleString("en-US"));
					},

					getDataEmbed: function (Event) {
                        var vue = this;

						// var editInit = window.FORM_EDIT;
						// var editVueInit = editInit.initVue;
						$.ajax({
                            url: that.urlGetData,
                            type: 'post',
							dataType: "json",
							data: {
								search: Event
							},
							success: function (response) {
								vue.$set(vue, 'groupData', response.detail_data);

							}
						});
					},

					getSelectedGroup: function (idx) {
						var vue = this;
						
						var listData = {};
						var groups = vue.groupData[idx].detail;

							for (x = 0; x < groups.length; x++) {
								var item = groups[x];

								listData[x] = {
									'no'          : item.no,
									'id'          : item.id,
									'code'        : item.code,
									'name'        : item.name,
									'description' : item.description,
									'unit'        : item.unit,
									'quantity'    : item.quantity,
									'notes'    		: item.notes,
									'group'       : item.group_name,
									'price'       : item.price,
									'img_filename': item.img_filename,
									'status'      : item.status
								};
							}

						vue.listData = listData;

						vue.$set(vue, 'groupSelected', idx);
						

						// console.log(listData);
					},

					getSelectedData: function (row, idx) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							// toastr.warning('Data sudah tersedia!')
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							editVueInit.detailData.splice(index, 1);
							vue.$set(vue.listData[idx], 'btncolor', 'btn-default');
							vue.$set(vue.listData[idx], 'btnicon', '');
						}else{
							editVueInit.detailData.push({
								id: row.id,
								name: row.name,
								lg_unit         : row.lg_unit,
								lg_unit_cnt     : row.lg_unit_cnt,
								lg_unit_qty     : row.lg_unit_qty,
								lg_unit_prc     : row.lg_unit_prc,
								md_unit         : row.md_unit,
								md_unit_cnt     : row.md_unit_cnt,
								md_unit_qty     : row.md_unit_qty,
								md_unit_prc     : row.md_unit_prc,
								sm_unit         : row.sm_unit,
								sm_unit_cnt     : row.sm_unit_cnt,
								sm_unit_qty     : row.sm_unit_qty,
								sm_unit_prc     : row.sm_unit_prc,
								// discount        : row.discount,
								// discount_total        : row.discount_total,
								result_large      : row.result_large,
								result_medium     : row.result_medium,
								result_small      : row.result_small,
								total             : row.total,
								minimum_stock         : row.minimum_stock,
								ppn_total         : row.ppn_total,
								ppn_status        : row.ppn_status,
								ppn_status_color  : row.ppn_status_color,
								bg_min_stock  : row.bg_min_stock,
								total_stock       : row.total_stock,
								total_stock_stored: row.total_stock_stored,
								remark: ''
							});
							vue.$set(vue.listData[idx], 'btncolor', 'btn-success');
							vue.$set(vue.listData[idx], 'btnicon', 'fa fa-check');
						}
						
						vue.checkData_isExists();
					},

					countPPN: function () {
						var vue = this;

						var totalOrder = 0;
						var totalAmmount = 0;
						var items = vue.orderData;
						
						for (var i in items) {
							totalOrder += parseFloat(items[i].total.replace(/,/g, ''));
						}

						totalAmmount = (totalOrder * 0.11);

						return totalAmmount.toLocaleString("en-US");
					},

					countTotal: function () {
						var vue = this;

						var totalAmmount = 0;
						var items = vue.orderData;
						
						for (var i in items) {
							totalAmmount += parseFloat(items[i].total.replace(/,/g, ''));
						}

						return totalAmmount.toLocaleString("en-US");
					},

					countTotalPPN: function () {
						var vue = this;

						var totalOrder = 0;
						var totalAmmount = 0;
						var total = 0;
						var items = vue.orderData;
						
						for (var i in items) {
							totalOrder += parseFloat(items[i].total.replace(/,/g, ''));
						}

						totalAmmount = (totalOrder * 0.11);
						total = parseFloat(totalOrder) + parseFloat(totalAmmount);

						return total.toLocaleString("en-US");
					},

					countQuantity: function () {
						var vue = this;

						var totalAmmount = 0;
						// var items = vue.orderData;
						
						// for (var i in items) {
						// 	totalAmmount += parseFloat(items[i].quantity);
						// }

						totalAmmount = vue.a.length;

						var txt = '';
						txt = totalAmmount +' Item';
						

						

						return txt
					},

					handlePrice: function (row, field_name, value) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;
						
						setTimeout(function () {
							window.INPUT.handleMaskCurrency();
						}, 100);
						vue.$set(row, field_name, value);

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], field_name, value);
						}

						vue.handleCount(row, field_name, value);
					},

					handleCount: function (row, field_name, value, wholesale_done) {
						var vue = this;
						
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						var result_large = 0;
						var result_medium = 0;
						var result_small = 0;
						var total = 0;
						// var discount = 0;
						// var sub_total = 0;

						if (field_name == 'lg_unit_qty' || field_name == 'lg_unit_prc') {
							result_large = (row.lg_unit_qty * row.lg_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_large', result_large);
							if (field_name == 'lg_unit_qty' && wholesale_done != 1) {
								vue.handleWholesalePrice(row, field_name, value);
								vue.handleStock(row, field_name, value);
							}
						}
						if (field_name == 'md_unit_qty' || field_name == 'md_unit_prc') {
							result_medium = (row.md_unit_qty * row.md_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_medium', result_medium);
							vue.handleStock(row, field_name, value);
						}
						if (field_name == 'sm_unit_qty' || field_name == 'sm_unit_prc') {
							result_small = (row.sm_unit_qty * row.sm_unit_prc.replace(/[^\w\s]/gi, ''));
							vue.$set(row, 'result_small', result_small);
							vue.handleStock(row, field_name, value);
						}

						result_large_total  = (row.result_large  == undefined ? "0" : row.result_large);
						result_medium_total = (row.result_medium == undefined ? "0" : row.result_medium);
						result_small_total  = (row.result_small  == undefined ? "0" : row.result_small);
						total = (Number(result_large_total) + Number(result_medium_total) + Number(result_small_total));

						// discount = total * row.discount / 100;
						// sub_total = total - discount;
						
						var ppn_total = 0
						if(row.ppn_status == '2'){
							var ppn_amount = $("#ppn_amount").val();
							    ppn_total  = (total * (ppn_amount/100));
						}
						vue.$set(row, 'ppn_total', ppn_total);
						vue.$set(row, 'total', (total + ppn_total).toLocaleString("en-US"));
						// vue.$set(row, 'total', sub_total.toLocaleString("en-US"));
						// vue.$set(row, 'discount_total', discount.toLocaleString("en-US"));

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);

							// This is the KEY : To Restore If Sometimes Get Error's
							vue.$set(editVueInit.detailData[index], field_name, value);

							vue.$set(editVueInit.detailData[index], 'result_large', result_large_total);
							vue.$set(editVueInit.detailData[index], 'result_medium', result_medium_total);
							vue.$set(editVueInit.detailData[index], 'result_small', result_small_total);
							// vue.$set(editVueInit.detailData[index], 'discount_total', discount.toLocaleString("en-US"));
							// vue.$set(editVueInit.detailData[index], 'total', sub_total.toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'total', (total + ppn_total).toLocaleString("en-US"));
							vue.$set(editVueInit.detailData[index], 'ppn_total', ppn_total);
						}
					},

					handleWholesalePrice: function (row, field_name, value) {
						var vue = this;

						$.ajax({
							type: "POST",
							url: window.APP.siteUrl + 'adm/sales_orders/get_wholesale_price',
							dataType: "JSON",
							data: {
								customer: $("#customer-select").val(),
								item: row.id,
								quantity_large: value
							},
							success: function (data) {
								vue.$set(row, 'lg_unit_prc', data);
								vue.handleCount(row, field_name, value, 1);
							},
						});
					},

					handleStock: function(row, field_name, value) {
						var vue = this;
						var editInit = window.FORM_EDIT;
						var editVueInit = editInit.initVue;

						lg_calc = 0;
						md_calc = 0;
						sm_calc = 0;

						calc = row.total_stock_stored;
						calc = (calc - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));

						if(calc < 0){
							toastr.warning('Stok tidak mencukupi!');
							if(field_name == 'lg_unit_qty'){
								vue.$set(row, 'lg_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								// vue.handleCount(row, field_name, value);
							}
							if(field_name == 'md_unit_qty'){
								vue.$set(row, 'md_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								// vue.handleCount(row, field_name, value);
							}
							if(field_name == 'sm_unit_qty'){
								vue.$set(row, 'sm_unit_qty', 0);
								calc = (row.total_stock_stored - ((row.lg_unit_qty * row.lg_unit_cnt) + (row.md_unit_qty * row.md_unit_cnt) + (row.sm_unit_qty * row.sm_unit_cnt)));
								// vue.handleCount(row, field_name, value);
							}
						}

						if (vue.checkValue_isExists(row.id, vue.a) == 'Exist') {
							index = editVueInit.detailData.map(function (item) {
								return item.id
							}).indexOf(row.id);
							
							vue.$set(editVueInit.detailData[index], 'total_stock', calc);
						}
						
						var left_stock_large = 0;
						left_stock_large = (calc/row.lg_unit_cnt);

						if(left_stock_large <= row.minimum_stock){
							toastr.error('Barang telah mencapai stok minimum!')
							vue.$set(row, 'bg_min_stock', 'bg-danger');
						}else{
							vue.$set(row, 'bg_min_stock', '');
						}

						vue.$set(row, 'total_stock', calc);
					},

					closeModal: function () {
						$(that.elClose).click();
					},

					checkData_isExists: function () {
						var vue = this;
						const a = [];
						const objectArray = Object.entries(vue.orderData);

						objectArray.forEach(([key, value]) => {
							a.push(value.id);
						});

						vue.a = a;

						// console.log(vue.a);

					},	

					checkValue_isExists: function (value, arr) {
						var vue = this;

						var status = 'Not exist';

						for (var i = 0; i < arr.length; i++) {
							var contains = arr[i];
							if (contains == value) {
								status = 'Exist';
								break;
							}
						}

						return status;
					}
				},
				mounted: function () {
					var vue = this;

					vue.getDataEmbed();
					vue.checkData_isExists();

					setTimeout(function () {
						that.handleForm();
					vue.getSelectedGroup(0);
						
					}, 500);
					
				}
			});

		},

		handleForm: function () {
			var that = this;

			$(that.elForm).validate();

			$(that.elForm).ajaxForm({
				beforeSend: function () {
					// $(that.elVue).block({
					// 	message: '<h4>Please Wait..</h4>'
					// });

					if (that.initVue.onBehalf == '') {
						Swal.fire( "Gagal" ,  "Mohon masukkan Atas Nama!" ,  "error" );
						$(that.elVue).unblock();
						return false;
					}
				},
				data: {
					vuedata: that.initVue.orderData
				},
				dataType: "json",
				success: function (response) {
					$(that.elVue).unblock();

					// window.FORM.showNotification(response.message, response.status);
					Swal.fire( "Terima Kasih" ,  "Pesanan anda akan segera kami proses!" ,  "success" );

					if (response.status == "success") {
							setTimeout(function () {
								// window.location.href = window.APP.siteUrl
								window.location.href = window.APP.siteUrl + 'adm/order/invoice'
							}, 1500);
					}
					
					if (response.status == "success") {
							setTimeout(function () {
								window.location.href = window.APP.siteUrl
								// window.location.href = window.APP.siteUrl + 'adm/order/invoice'
							}, 1500);
					}

				}
			});

        },
	}
})(jQuery);