/**
 * Javascript Programs
 *
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 *
 */
window.REPORT = (function ($) {

	return {

		elDatatable: null,
		elVue: '#vue-master',
		elDate_1: '.date_1',
		elDate_2: '.date_2',

		urlRequestData: window.APP.siteUrl + 'adm/report_ppn/get_data_outcome',

		urlBahasa: window.APP.baseUrl + 'assets/js/vendor/indonesia.json',

		init: function () {
			var that = this;

			that.handleVue();
		},

		// Master
		handleVue: function () {
			var that = this;

			// Vue Js
			new Vue({
				el: that.elVue,
				delimiters: ['<%', '%>'],
				data: {
					elDate_1: '',
					elDate_2: '',
					date_1: '',
					date_2: '',
					totalOutcome: 0,
					detailData: []
				},
				methods: {
					getData: function () {
						var vue = this;

						var val_date_1 = $(that.elDate_1).val();
						var val_date_2 = $(that.elDate_2).val();

						// console.log("ADS");
						$.ajax({
							url: that.urlRequestData,
							type: 'post',
							data: {
								'date_1': val_date_1,
								'date_2'  : val_date_2
							},
							dataType: "json",
							// beforeSend : function() {
							// 	$(that.elVue).block({
							// 		message: '<h4>Please Wait..</h4>'
							// 	});
							// },
							success: function (response) {
								vue.$set(vue, 'detailData', response['data']);

								vue.$set(vue, 'date_1', response['date_1']);
								vue.$set(vue, 'date_2', response['date_2']);
								vue.$set(vue, 'totalOutcome', response['total_outcome']);

								$(that.elVue).unblock();
							}
						});
					},

					exportExcel: function () {
						var vue = this;
						vue.getData();

						setTimeout(function () {
							window.location = window.APP.siteUrl + 'adm/report_ppn/export_excel';
						}, 500);
					}
				},
				mounted: function () {

				}
			});

		},

	}

})(jQuery);